package com.atlassian.confluence.plugins.jirareports;

import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.http.ConfluenceHttpParameters;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;

import java.util.Map;

/**
 * This class will setup configuration to meta
 *
 * @since 2.1
 */
public class JiraReportsConfigurationContextProvider implements ContextProvider {

    private SettingsManager settingsManager;

    @Override
    public void init(Map<String, String> paramMap) throws PluginParseException {
    }

    @Override
    public Map<String, Object> getContextMap(Map<String, Object> contextMap) {
        int connectionTimeout = ConfluenceHttpParameters.DEFAULT_CONNECTION_TIMEOUT;
        Settings globalSettings = settingsManager.getGlobalSettings();
        if (globalSettings != null && globalSettings.getConfluenceHttpParameters() != null) {
            connectionTimeout = globalSettings.getConfluenceHttpParameters().getConnectionTimeout();
        }
        contextMap.put("connectionTimeout", connectionTimeout);
        return contextMap;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }
}
