package com.atlassian.confluence.plugins.jirareports;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.confluence.extra.jira.Channel;
import com.atlassian.confluence.plugins.SoftwareBlueprintsContextProviderHelper;
import com.atlassian.confluence.plugins.common.event.SoftwareBPAnalyticEventUtils;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.AbstractBlueprintContextProvider;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.BlueprintContext;
import org.apache.log4j.Logger;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @since 2.3.3
 */
public class ChangeLogSimpleDialogContextProvider extends AbstractBlueprintContextProvider {

    private static final Logger LOGGER = Logger.getLogger(ChangeLogSimpleDialogContextProvider.class);
    private SoftwareBlueprintsContextProviderHelper helper;
    private ApplicationLinkService appLinkService;
    private JiraIssuesHelper jiraIssuesHelper;
    private static final int MAX_RESULT = 1000;

    public ChangeLogSimpleDialogContextProvider(SoftwareBlueprintsContextProviderHelper helper, ApplicationLinkService appLinkService, JiraIssuesHelper jiraIssuesHelper) {
        this.helper = helper;
        this.appLinkService = appLinkService;
        this.jiraIssuesHelper = jiraIssuesHelper;
    }

    @Override
    protected BlueprintContext updateBlueprintContext(BlueprintContext context) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(helper.getDateFormat(), helper.getAuthenticatedUserLocale());
        context.put("date", simpleDateFormat.format(new Date()));
        setupStaticContent(context);

        //analytic for create changelog bp
        helper.publishAnalyticEvent(SoftwareBPAnalyticEventUtils.CHANGELOG_CREATE_EVENT_NAME);
        helper.publishAnalyticEvent(SoftwareBPAnalyticEventUtils.CHANGELOG_CREATE_STATIC_EVENT_NAME);
        helper.publishAnalyticEvent(SoftwareBPAnalyticEventUtils.CHANGELOG_CREATE_SIMPLE_EVENT_NAME);

        return context;
    }

    private void setupStaticContent(BlueprintContext contextMap) {
        String appId = (String) contextMap.get("jira-reports-servers");
        if (appId != null) {
            try {
                ReadOnlyApplicationLink appLink = appLinkService.getApplicationLink(new ApplicationId(appId));
                String projectVersionJql = jiraIssuesHelper.buildProjectVersionJQL(contextMap.getMap());
                if (projectVersionJql != null) {
                    String jql = URLEncoder.encode(projectVersionJql, "UTF-8");
                    Channel channel = jiraIssuesHelper.getChannel(appLink, jql, MAX_RESULT);
                    contextMap.put("jiraIssues", jiraIssuesHelper.renderJiraIssues(channel));
                    contextMap.put("jiraIssuesCount", jiraIssuesHelper.getTotalIssueNumber(channel) + " "
                            + helper.getText("jirareports.changelog.blueprint.total.issues.title"));
                }
            } catch (Exception e) {
                LOGGER.error("Can not render jira issues", e);
            }
        }
    }
}
