package com.atlassian.confluence.plugins.common.event;

import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import org.springframework.beans.factory.DisposableBean;

/**
 * @since 2.3.3
 */
public class SoftwareBPPageViewListener implements DisposableBean {

    private EventPublisher eventPublisher;

    public SoftwareBPPageViewListener(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        eventPublisher.register(this);
    }

    @EventListener
    public void viewPageEvent(PageViewEvent pageViewEvent) {
        String eventName = SoftwareBPAnalyticEventUtils.getAnalyticEventName(pageViewEvent.getContent().getLabels());
        if (eventName != null) {
            eventPublisher.publish(new SoftwareBPAnalyticEvent(eventName));
        }
    }

    @Override
    public void destroy() throws Exception {
        eventPublisher.unregister(this);
    }
}
