/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.jirareports;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.confluence.extra.jira.JiraIssuesManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class JiraIssuesHelper {
    private JiraIssuesManager jiraIssuesManager;
    private static final Logger LOGGER = Logger.getLogger(JiraIssuesHelper.class);
    private static final List<String> DEFAULT_COLUMNS = Arrays.asList("key", "summary", "status", "type");
    private static final String XML_SEARCH_REQUEST_URI = "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?jqlQuery=";
    private static final String JIRA_ISSUES_TEMPLATE = "com/atlassian/confluence/plugins/jirareports/velocity/jira-issues.html.vm";
    private static final List<String> DEFAULT_ISSUE_TYPES = Arrays.asList("Epic", "New Feature", "Improvement", "Bug");
    private static final String EMPTY_RESULT = "";
    private static final int DEFAULT_TOTAL_ISSUES = 0;
    private static final String DEFAULT_OPTION_VALUE = "-1";

    public JiraIssuesHelper(JiraIssuesManager jiraIssuesManager) {
        this.jiraIssuesManager = jiraIssuesManager;
    }

    public String renderJiraIssues(JiraIssuesManager.Channel channel) {
        Element jiraIssuesElement;
        List items;
        if (channel != null && (items = (jiraIssuesElement = channel.getChannelElement()).getChildren("item")) != null && !items.isEmpty()) {
            StringBuilder jiraIssues = new StringBuilder();
            Map<String, List<Element>> mapIssueTypes = this.getMapIssueType(items);
            this.appendDefaultIssueTypes(mapIssueTypes, jiraIssues);
            this.appendOtherIssueTypes(mapIssueTypes, jiraIssues);
            return jiraIssues.toString();
        }
        return EMPTY_RESULT;
    }

    public int getTotalIssueNumber(JiraIssuesManager.Channel channel) {
        Element jiraIssuesElement;
        Element totalItemsElement;
        if (channel != null && (totalItemsElement = (jiraIssuesElement = channel.getChannelElement()).getChild("issue")) != null) {
            return Integer.parseInt(totalItemsElement.getAttributeValue("total"));
        }
        return 0;
    }

    private void appendDefaultIssueTypes(Map<String, List<Element>> mapIssueTypes, StringBuilder jiraIssues) {
        for (String issueType : DEFAULT_ISSUE_TYPES) {
            if (mapIssueTypes.get(issueType) == null) continue;
            jiraIssues.append(this.velocityRender(mapIssueTypes, issueType));
        }
    }

    private void appendOtherIssueTypes(Map<String, List<Element>> mapIssueTypes, StringBuilder jiraIssues) {
        Set<String> keys = mapIssueTypes.keySet();
        for (String key : keys) {
            if (DEFAULT_ISSUE_TYPES.contains(key)) continue;
            jiraIssues.append(this.velocityRender(mapIssueTypes, key));
        }
    }

    private String velocityRender(Map<String, List<Element>> mapIssueTypes, String issueType) {
        Map context = MacroUtils.defaultVelocityContext();
        context.put("title", issueType);
        context.put("issues", mapIssueTypes.get(issueType));
        return VelocityUtils.getRenderedTemplate((String)JIRA_ISSUES_TEMPLATE, (Map)context);
    }

    private Map<String, List<Element>> getMapIssueType(List<Element> elements) {
        HashMap<String, List<Element>> mapIssueType = new HashMap<String, List<Element>>();
        for (Element element : elements) {
            String type = element.getChild("type").getValue();
            if (mapIssueType.get(type) == null) {
                ArrayList<Element> list = new ArrayList<Element>();
                list.add(element);
                mapIssueType.put(type, list);
                continue;
            }
            ((List)mapIssueType.get(type)).add(element);
        }
        return mapIssueType;
    }

    public String buildProjectVersionJQL(Map<String, Object> contextMap) {
        String project = (String)contextMap.get("jira-reports-project");
        if (project == null || project.equals(DEFAULT_OPTION_VALUE)) {
            return null;
        }
        StringBuilder url = new StringBuilder();
        url.append("project=\"");
        url.append(StringEscapeUtils.escapeSql((String)project));
        url.append("\"");
        String versions = (String)contextMap.get("multiVersion");
        if (!StringUtils.isBlank((String)versions)) {
            url.append(" AND fixVersion in (");
            url.append(StringEscapeUtils.escapeSql((String)versions));
            url.append(")");
        }
        return url.toString();
    }

    public JiraIssuesManager.Channel getChannel(ReadOnlyApplicationLink appLink, String jqlQuery, int maxResult) {
        String hostName = appLink.getRpcUrl().toString();
        String requestJiraUrl = hostName + XML_SEARCH_REQUEST_URI + jqlQuery + "&tempMax=" + maxResult;
        try {
            return this.jiraIssuesManager.retrieveXMLAsChannel(requestJiraUrl, DEFAULT_COLUMNS, appLink, false, false);
        }
        catch (CredentialsRequiredException e) {
            return this.getChannelByAnonymous(requestJiraUrl, appLink);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Can not retrieve jira issues", (Throwable)e);
            return null;
        }
    }

    private JiraIssuesManager.Channel getChannelByAnonymous(String url, ReadOnlyApplicationLink appLink) {
        try {
            return this.jiraIssuesManager.retrieveXMLAsChannelByAnonymous(url, DEFAULT_COLUMNS, appLink, false, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Can not retrieve jira issues", (Throwable)e);
            return null;
        }
    }
}

