/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.roadmap;

import com.atlassian.plugins.roadmap.TimelinePlannerMacroManager;
import com.atlassian.plugins.roadmap.models.RoadmapPageLink;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.vcache.ExternalCacheSettingsBuilder;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.MarshallerException;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.marshallers.MarshallerFactory;
import java.time.Duration;
import javax.annotation.Nonnull;

class RoadmapMacroCacheSupplier {
    private final Supplier<StableReadExternalCache<byte[]>> imageCacheRef = Lazy.supplier(() -> RoadmapMacroCacheSupplier.createImageCache(cacheFactory));
    private final Supplier<StableReadExternalCache<String>> macroSourceCacheRef = Lazy.supplier(() -> RoadmapMacroCacheSupplier.createMacroSourceCache(cacheFactory));
    private final Supplier<StableReadExternalCache<TimelinePlannerMacroManager.LinkStatus>> linkStatusCacheRef = Lazy.supplier(() -> RoadmapMacroCacheSupplier.createLinkStatusCache(cacheFactory));
    private final Supplier<StableReadExternalCache<RoadmapPageLink>> pageLinkCacheRef = Lazy.supplier(() -> RoadmapMacroCacheSupplier.createPageLinkCache(cacheFactory));
    public static final String IMAGE_CACHE_NAME = "RoadmapMacroImages";
    public static final String MACRO_SOURCE_CACHE_NAME = "RoadmapMacroSources";
    public static final String LINK_STATUS_CACHE_NAME = "RoadmapMacroLinkStatuses";
    public static final String PAGE_LINK_CACHE_NAME = "RoadmapMacroPageLinks";

    RoadmapMacroCacheSupplier(VCacheFactory cacheFactory) {
    }

    private static StableReadExternalCache<byte[]> createImageCache(VCacheFactory cacheFactory) {
        ByteArrayMarshaller marshaller = new ByteArrayMarshaller();
        return cacheFactory.getStableReadExternalCache(IMAGE_CACHE_NAME, (Marshaller)marshaller, new ExternalCacheSettingsBuilder().build());
    }

    private static StableReadExternalCache<String> createMacroSourceCache(VCacheFactory cacheFactory) {
        return cacheFactory.getStableReadExternalCache(MACRO_SOURCE_CACHE_NAME, MarshallerFactory.stringMarshaller(), new ExternalCacheSettingsBuilder().build());
    }

    private static StableReadExternalCache<TimelinePlannerMacroManager.LinkStatus> createLinkStatusCache(VCacheFactory cacheFactory) {
        return cacheFactory.getStableReadExternalCache(LINK_STATUS_CACHE_NAME, MarshallerFactory.serializableMarshaller(TimelinePlannerMacroManager.LinkStatus.class), new ExternalCacheSettingsBuilder().defaultTtl(Duration.ofHours(3L)).build());
    }

    private static StableReadExternalCache<RoadmapPageLink> createPageLinkCache(VCacheFactory cacheFactory) {
        return cacheFactory.getStableReadExternalCache(PAGE_LINK_CACHE_NAME, MarshallerFactory.serializableMarshaller(RoadmapPageLink.class), new ExternalCacheSettingsBuilder().defaultTtl(Duration.ofHours(3L)).build());
    }

    public StableReadExternalCache<byte[]> getImageCache() {
        return (StableReadExternalCache)this.imageCacheRef.get();
    }

    public StableReadExternalCache<String> getMarcoSourceCache() {
        return (StableReadExternalCache)this.macroSourceCacheRef.get();
    }

    public StableReadExternalCache<TimelinePlannerMacroManager.LinkStatus> getLinkStatusCache() {
        return (StableReadExternalCache)this.linkStatusCacheRef.get();
    }

    public StableReadExternalCache<RoadmapPageLink> getPageLinkCache() {
        return (StableReadExternalCache)this.pageLinkCacheRef.get();
    }

    public static class ByteArrayMarshaller
    implements Marshaller<byte[]> {
        @Nonnull
        public byte[] marshall(byte[] obj) throws MarshallerException {
            return obj;
        }

        @Nonnull
        public byte[] unmarshall(byte[] raw) throws MarshallerException {
            return raw;
        }
    }
}

