(function(b,a){window.Roadmap=window.Roadmap||{};Roadmap.RoadmapEditorView=Backbone.View.extend({className:"roadmap-editor-container",events:{"BarView.add":"_onAddBar","BarView.dragstart":"_onBarDragstart","BarView.dragstop":"_onBarDragstop","BarView.drop":"_onBarDropped","LaneView.drop":"_onBarDropped","Lane.delete":"_onDeleteLane","BarRowView.remove":"_onBarRowViewRemove","sortstart .roadmap-content":"_onSortStart","sortstop .roadmap-content":"_onSortStop",remove:"_onRemove"},initialize:function(){a.bindAll(this,"render");this.listenTo(this.model.get("lanes"),"add",function(c){var d=new Roadmap.LaneView({model:c,timelineView:this._timelineView,canDelete:true});if(this._laneViews.length===1){this._laneViews[0].updateDeleteStatus(true)}this._laneViews.push(d);this.$roadmapContent.append(d.render().$el);this._updateTimelineColumnHeight();this._scrollToBottom()});this.listenTo(this.model.get("markers"),"add",function(c){var d=new Roadmap.MarkerView({model:c,roadmap:this});this.$roadmapMarker.append(d.render().$el);this._markerViews.push(d)});this.listenTo(this.model.get("timeline"),"change",function(){if(this._isTimelineChanged()){this._calculateMinWidthOfABar();this._timelineView.update();this._timelineColumnView.update();this.$roadmapContent.empty();a.each(this._laneViews,function(c){c.remove()});this._laneViews=[];this._renderLanes();this.$roadmapMarker.empty();this._markerViews=[];this._renderMarkers();this._updateDragArea()}})},render:function(){this.$el.html(Confluence.Templates.Roadmap.roadmapEditor());this._calculateMinWidthOfABar();this._initVariables();this._renderToolbar();this._renderTimeline();this._renderLanes();this._renderMarkers();this._renderTimelineColumn();this._updateDragArea();return this},_calculateMinWidthOfABar:function(){Roadmap.barMinWidth=this.model.get("timeline").get("displayOption")===Roadmap.TIMELINE_DISPLAY_OPTION.MONTH?Roadmap.MONTH_BAR_MIN_WIDTH:Roadmap.WEEK_BAR_MIN_WIDTH},_initVariables:function(){this.$roadmapContainer=this.$el.find("#roadmap-container");this.$roadmapTimeline=this.$roadmapContainer.find(".roadmap-frame");this.$roadmapContent=this.$roadmapContainer.find(".roadmap-content");this.$roadmapMarker=this.$roadmapContainer.find(".roadmap-marker");this._timelineView=new Roadmap.TimelineView({model:this.model.get("timeline")});this._timelineColumnView=new Roadmap.TimelineColumnView({model:this.model.get("timeline")});this._laneViews=[];this._markerViews=[]},_renderTimeline:function(){this.$roadmapTimeline.prepend(this._timelineView.render().$el)},_renderTimelineColumn:function(){this._updateTimelineColumnHeight();this.$roadmapTimeline.append(this._timelineColumnView.render().$el)},_renderMarkers:function(){var c=this;this.model.get("markers").each(function(d){var e=new Roadmap.MarkerView({model:d,roadmap:c});c.$roadmapMarker.append(e.render().$el);c._markerViews.push(e)})},_renderLanes:function(){Confluence.Roadmap.ColorHelper.resetColorCounts();var d=this;this._updateLaneWidth();var c=this.model.get("lanes").models.length>1;this.model.get("lanes").each(function(e){var f=new Roadmap.LaneView({model:e,timelineView:d._timelineView,canDelete:c});d._laneViews.push(f);d.$roadmapContent.append(f.render().$el)});this._setupLaneReordering()},_onAddBar:function(d,c){this._updateTimelineColumnHeight();var e=c.$el;if(!this._isInViewScreen(e)){this._scrollToBar(e)}},_renderToolbar:function(){var d=b("#"+this.options.dialogId+" .aui-dialog2-content");d.find(".roadmap-toolbar").remove();var c=new Roadmap.ToolbarView({model:this.model,timelineView:this._timelineView});d.prepend(c.render().$el)},_getTimelineWidth:function(){return this.$roadmapTimeline.find(".roadmap-frame-title").width()},_getLaneHeight:function(){return this.$roadmapContent.height()},_updateLaneWidth:function(){this.$roadmapContent.width(this._getTimelineWidth()+Roadmap.LANE_TITLE_WIDTH)},_scrollToBottom:function(){this.options.roadmapEditorPopup.scrollTop(this._getLaneHeight())},_isInViewScreen:function(c){return b.inviewport(c,{threshold:-200})},_scrollToBar:function(c){this.options.roadmapEditorPopup.scrollTop(c.parent().position().top);this.options.roadmapEditorPopup.scrollLeft(0)},_onBarDropped:function(){this._updateTimelineColumnHeight()},_onDeleteLane:function(d,c){this.model.get("lanes").remove(c.model);this._laneViews.splice(a.indexOf(this._laneViews,c),1);c.remove();this._updateTimelineColumnHeight();if(this._laneViews.length===1){this._laneViews[0].updateDeleteStatus(false)}},_onBarRowViewRemove:function(){this._updateTimelineColumnHeight()},_updateTimelineColumnHeight:function(){var c=this._getLaneHeight();this._timelineColumnView.updateHeight(c);a.each(this._markerViews,function(d){d.updateHeight(c)})},hideDialog:function(){b("#inline-dialog-roadmap-dialog, #inline-dialog-timeline-options").hide()},removeDialog:function(){b("#inline-dialog-roadmap-dialog, #inline-dialog-timeline-options").remove()},_onBarDragstart:function(f,d){var c=this;this.hideDialog();this._updateDragArea();this._barRowNewViewList=[];a.each(this._laneViews,function(e){c._barRowNewViewList.push(e.addNewBarRow(d.helper))})},_updateDragArea:function(){var c=this.$roadmapContainer.find(".roadmap-drag-area");c.css(this._timelineColumnView.getSizeAndPosition())},_onBarDragstop:function(){a.each(a.flatten(this._barRowNewViewList),function(c){c.remove()});delete this._barRowNewViewList;a.each(this._laneViews,function(c){c.removeEmptyRow()})},_setupLaneReordering:function(){this.$roadmapContent.sortable({axis:"y",cursor:"move",handle:".roadmap-lane-title",opacity:0.3,placeholder:"roadmap-lane lane-sorting-placeholder",helper:function(d,c){return b(c).clone().addClass("lane-sorting-hepler")}})},_onSortStart:function(d,c){this.hideDialog();this._timelineColumnView.$el.hide();c.placeholder.css({height:Math.min(c.helper.height(),100),width:c.helper.width()}).html(Confluence.Templates.Roadmap.lane(Roadmap.TRANSPARENT_LANE));c.helper.find(".roadmap-lane-content").css({width:c.helper.width()-(c.helper.find(".roadmap-lane-title").outerWidth()+c.helper.find(".roadmap-separate-content").outerWidth())})},_onSortStop:function(h,g){this._timelineColumnView.$el.show();var d=g.item.attr("cid");var f=a.find(this._laneViews,function(e){return e.cid===d});var c=f.model;var i=this.model.get("lanes");i.remove(c);i.models.splice(g.item.index(),0,c);i._byId[c.cid]=c},_onRemove:function(){this.$roadmapTimeline.remove()},_isMonthYearChanged:function(){var d=function(f,e){if(f.getMonth()!==e.getMonth()||f.getYear()!==e.getYear()){return true}return false};var c=this.model.get("timeline");return d(c._previousAttributes.startDate,c.attributes.startDate)||d(c._previousAttributes.endDate,c.attributes.endDate)},_isWeekChanged:function(){var c=function(l,k){var j=moment(l);var i=moment(k);return j.get("year")===i.get("year")&&j.isoWeek()===i.isoWeek()};var d=this.model.get("timeline");var g=d._previousAttributes.startDate;var h=d.attributes.startDate;var f=d._previousAttributes.endDate;var e=d.attributes.endDate;return !(c(g,h)&&c(f,e))},_isTimelineChanged:function(){var d=this.model.get("timeline");var c=d.changed.displayOption;if(c){this.model.updateDurationUnit(d.get("displayOption"))}else{c=d.get("displayOption")===Roadmap.TIMELINE_DISPLAY_OPTION.MONTH?this._isMonthYearChanged():this._isWeekChanged()}return c},resize:function(){this._updateLaneWidth();this._updateTimelineColumnHeight();this.$roadmapContent.css({top:this.$roadmapTimeline.find(".roadmap-column-title:first").innerHeight()})}})})(AJS.$,window._);