require([
    'ajs',
    'jquery',
    'confluence/legacy',
    'confluence/meta'
], function (AJS,
             $,
             Confluence,
             Meta) {
    AJS.toInit(function () {
        var pageId = Meta.get("page-id");
        var grantAccessUser = Meta.get("remote-user");
        var requestAccessUsername = getParameterByName("username");
        var requestAccessType = getParameterByName("accessType");
        var requestAccessFullName = getParameterByName("userFullName");

        // DOM element that includes the padlock will be the trigger, otherwise the inline dialog's arrow looks funny
        // as the the padlock is too small
        var $trigger = $("#system-content-items");
        // Figure out if the padlock is shown
        var isPageRestricted = $("#content-metadata-page-restrictions.restricted").length !== 0;
        var $restrictedPadlock = $("#rte-button-restrictions");

        var isGrantAccessOnEditPage = _isEditPage() && $restrictedPadlock.length &&
            getParameterByName("grantAccess") && requestAccessType;
        // If padlock is not present, or URL does not have certain params we can't show grant access dialog
        var viewPageRestrictionDialogCanBeShown = $trigger.length && isPageRestricted &&
            getParameterByName("grantAccess") && requestAccessType;

        if (!viewPageRestrictionDialogCanBeShown && !isGrantAccessOnEditPage) {
            return;
        }

        if (isGrantAccessOnEditPage) {
            // It's a restricted edit page and someone is requesting access.
            // Some elements are different on edit pages (as opposed to view pages)
            $trigger = $restrictedPadlock;
            pageId = Meta.get("draft-id");
        }

        var loading = $(Confluence.Request.Access.loading());

        var grantAccessDialog = AJS.InlineDialog($trigger, "grantAccessDialog",
            function (content, trigger, showPopup) {
                content.css({"padding": "20px"}).html(
                    Confluence.Grant.Access.dialog(
                        {
                            requestAccessUsername: requestAccessUsername,
                            requestAccessUserFullName: requestAccessFullName,
                            requestAccessType: requestAccessType,
                            contentType: Meta.get('content-type')
                        }
                    )
                );
                content.on("click", '.aui-button.grant-access', function (e) {
                    e.stopPropagation();

                    var grantAccessButtons = content.find(".actions-result");
                    grantAccessButtons.replaceWith(loading);

                    // Logged in user grants access to the user requesting access
                    AJS.trigger('analyticsEvent', {
                        name: 'confluence.request.access.plugin.grant.access.to.page',
                        data: {
                            pageId: pageId,
                            grantAccessUser: grantAccessUser,
                            requestAccessUser: requestAccessUsername,
                            accessType: requestAccessType
                        }
                    });

                    var grantAccessResultMessage = "";

                    $.ajax({
                        url: Confluence.getContextPath() + "/rest/access/latest/page/restriction/" + pageId + "/grant/" + requestAccessType,
                        type: "POST",
                        contentType: "application/json; charset=utf-8",
                        data: requestAccessUsername,
                        success: function (data, textStatus, jqXHR) {
                            if (jqXHR.status == 202) {
                                grantAccessResultMessage = AJS.I18n.getText("confluence.request.access.already.granted");
                            } else {
                                grantAccessResultMessage = AJS.I18n.getText("confluence.request.access.notification.sent");
                            }

                            AJS.flag({
                                type: 'success',
                                title: AJS.I18n.getText('confluence.request.access.flag.success.title'),
                                body: grantAccessResultMessage
                            });
                        },
                        error: function (xhr) {
                            if (xhr.status == 412) {
                                grantAccessResultMessage = AJS.I18n.getText("confluence.request.access.no.mail.server");
                            } else if (xhr.status == 502) {
                                grantAccessResultMessage = AJS.I18n.getText("confluence.request.access.error.sending.email");
                            } else {
                                grantAccessResultMessage = AJS.I18n.getText("confluence.request.access.error");
                            }

                            AJS.flag({
                                type: 'error',
                                title: AJS.I18n.getText('confluence.request.access.flag.error.title'),
                                body: grantAccessResultMessage
                            });
                        },
                        complete: function (xhr) {
                            grantAccessDialog.hide();
                        }
                    });
                });

                content.on("click", '.aui-button.deny-access', function (e) {
                    // Logged in user explicitly denies access to the user requesting access
                    AJS.trigger('analyticsEvent', {
                        name: 'confluence.request.access.plugin.deny.access.to.page',
                        data: {
                            pageId: pageId,
                            grantAccessUser: grantAccessUser,
                            requestAccessUser: requestAccessUsername,
                            accessType: requestAccessType
                        }
                    });
                    grantAccessDialog.hide();
                });
                showPopup();
                return false;
            },
            {
                offsetY: 2,
                offsetX: 0,
                width: 350,
                hideDelay: null,
                noBind: true,
                hideCallback: function () {
                    setTimeout(grantAccessDialog.hide(), 5000);
                }
            }
        );

        grantAccessDialog.show();

        function getParameterByName(name) {
            name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
            var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
                results = regex.exec(location.search);
            return results == null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
        }

        /**
         * @returns {boolean} true if the user is creating/editing a page, or a blogpost, as opposed to a comment, or something.
         * @private
         */
        function _isEditPage() {
            return AJS.Rte && AJS.Rte.getEditor() && (!!AJS.$('#editpageform').length || !!AJS.$('#createpageform').length);
        }

    });
});
