define('confluence/request-access/request-access-util',
    ['confluence/legacy'],
    function (Confluence) {
        /**
         * Depending on the number of users we should customize the info message.
         *
         * @param {object} users -- recipients of the RequestAccess message returned by Confluence REST API
         */
        var messageBody = function messageBody(users) {
            if (users.length === 1) {
                // If email was sent only to one recipient, just include it's name
                return AJS.I18n.getText('confluence.request.access.pagerestricted.access.request.sent.single.recipient.message',
                    Confluence.Request.Access.usernameLink({user: users[0]}));
            }

            if (users.length === 2) {
                // If email was sent to exactly two recipients, print their logins
                return AJS.I18n.getText('confluence.request.access.pagerestricted.access.request.sent.two.recipients.message',
                    Confluence.Request.Access.usernameLink({user: users[0]}),
                    Confluence.Request.Access.usernameLink({user: users[1]}));
            }

            if (users.length === 3) {
                // If email was sent to exactly three recipients, print the first two only
                return AJS.I18n.getText('confluence.request.access.pagerestricted.access.request.sent.three.recipients.message',
                    Confluence.Request.Access.usernameLink({user: users[0]}),
                    Confluence.Request.Access.usernameLink({user: users[1]}));
            }

            // In this case email was sent to more than three recipients. Not to disclosure all names, we will write first two only
            return AJS.I18n.getText('confluence.request.access.pagerestricted.access.request.sent.many.recipients.message',
                Confluence.Request.Access.usernameLink({user: users[0]}),
                Confluence.Request.Access.usernameLink({user: users[1]}),
                users.length - 2);
        };

        return {
            messageBody: messageBody
        };
    });