/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.replytoemail;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.notification.NotificationEmailHelper;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.plugins.emailgateway.api.AttachmentConverterService;
import com.atlassian.confluence.plugins.emailgateway.api.EmailContentParser;
import com.atlassian.confluence.plugins.emailgateway.api.EmailHandler;
import com.atlassian.confluence.plugins.emailgateway.api.EmailHandlingException;
import com.atlassian.confluence.plugins.emailgateway.api.ReceivedEmail;
import com.atlassian.confluence.plugins.emailgateway.api.UsersByEmailService;
import com.atlassian.confluence.plugins.replytoemail.EmailQuoteRegex;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class ReplyToEmailHandler
implements EmailHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReplyToEmailHandler.class);
    private final ContentEntityManager contentEntityManager;
    private final CommentManager commentManager;
    private final TransactionTemplate transactionTemplate;
    private final UsersByEmailService usersByEmailService;
    private final EmailContentParser emailContentParser;
    private final AttachmentConverterService attachmentConverterService;

    public ReplyToEmailHandler(@Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, CommentManager commentManager, TransactionTemplate transactionTemplate, UsersByEmailService usersByEmailService, EmailContentParser emailContentParser, AttachmentConverterService attachmentConverterService) {
        this.contentEntityManager = contentEntityManager;
        this.commentManager = commentManager;
        this.transactionTemplate = transactionTemplate;
        this.usersByEmailService = usersByEmailService;
        this.emailContentParser = emailContentParser;
        this.attachmentConverterService = attachmentConverterService;
    }

    public boolean handle(final ReceivedEmail email) throws EmailHandlingException {
        return (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction() {
                return ReplyToEmailHandler.this.handleEmail(email);
            }
        });
    }

    private boolean handleEmail(ReceivedEmail email) {
        LOG.debug("Checking inbound message from {} to see if it's a reply to an earlier notification", (Object)email.getSender());
        ContentEntityObject target = NotificationEmailHelper.extractTargetContentFromNotificationEmailReply((Map)email.getHeaders().getAllHeaders(), (NotificationEmailHelper.ContentFinder)new NotificationEmailHelper.ContentFinder(){

            public ContentEntityObject findContentById(long contentId) {
                return ReplyToEmailHandler.this.findContentObject(contentId);
            }
        });
        if (target != null) {
            try {
                LOG.debug("Adding email as a comment to {} {}", (Object)target.getClass().getSimpleName(), (Object)target.getId());
                this.attachEmailAsComment(email, target);
                LOG.info("Comment added successfully to {} {}", (Object)target.getClass().getSimpleName(), (Object)target.getId());
            }
            catch (EntityException e) {
                LOG.error("Failed to persist email reply comment", (Throwable)e);
            }
            return true;
        }
        LOG.debug("Email was not a reply to notification, skipping");
        return false;
    }

    private void attachEmailAsComment(ReceivedEmail email, ContentEntityObject target) throws EntityException {
        ContentEntityObject targetOwner;
        Comment parentComment;
        User user = this.usersByEmailService.getUniqueUserByEmail(email.getSender());
        if (user == null) {
            LOG.debug("Received email from address which does not correspond to a Confluence user. Ignoring it.");
            return;
        }
        if (target instanceof Comment) {
            parentComment = (Comment)target;
            targetOwner = parentComment.getContainer();
        } else {
            parentComment = null;
            targetOwner = target;
        }
        String content = this.prepareCommentContent(email);
        List attachments = email.getAttachments();
        this.attachmentConverterService.attachTo(targetOwner, attachments);
        this.persistNewComment(user, parentComment, targetOwner, content);
    }

    private String prepareCommentContent(ReceivedEmail email) {
        switch (email.getBodyType()) {
            case HTML: {
                return this.removeQuotedResponseSection(email.getBodyContentAsString());
            }
        }
        return this.removeQuotedResponseSection(this.emailContentParser.parseContent(email));
    }

    private String removeQuotedResponseSection(String htmlContent) {
        Matcher matcher = EmailQuoteRegex.REPLY_EMAIL_HEADING.matcher(htmlContent);
        if (matcher.find()) {
            int quoteStartIndex = matcher.start();
            String strippedContent = htmlContent.substring(0, quoteStartIndex);
            return strippedContent;
        }
        LOG.warn("Failed to clean HTML, returning as-is");
        return htmlContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistNewComment(User user, Comment parentComment, ContentEntityObject targetOwner, String content) {
        AuthenticatedUserThreadLocal.setUser((User)user);
        try {
            this.commentManager.addCommentToObject(targetOwner, parentComment, content);
        }
        finally {
            AuthenticatedUserThreadLocal.reset();
        }
    }

    private ContentEntityObject findContentObject(long contentId) {
        return this.contentEntityManager.getById(contentId);
    }
}

