
# MediaViewer

MediaViewer is Atlassian's powerful solution for viewing files on the web. It's both powerful and extendable yet easy-to-integrate.

_Note: The MediaViewer was previously known as FileViewer_

## MediaViewer features

- Inbuilt support for viewing document, image, audio & video files
- Interface for adding custom viewers, ui elements & actions
- Full-screen & presentation mode
- Mini-preview mode
- Youtube video support
- HD video support
- Embedded mode (multiple viewers in a single page) (new in 2.0)
- 3D viewer support (new in 2.0)
- Annotation support (currently bound to Confluence only)
- Analytics support (ReleaseBuster, ...)
- Webpack chunks loading (new in 2.0)

## MediaViewer examples

[go/mediaviewer-examples](go/mediaviewer-examples)

.. or checkout the `/examples/` folder.

## Consuming the MediaViewer component

There's an [integration guide](./docs/integration_guide.md) and [api documentation](./docs/api.md).

We also recommend to study the examples, as they cover different use cases (plugins, instantiating MediaViewer from global, using AMD, etc).

## Contributing to the MediaViewer

Please have a look at the [MediaViewer documentation in EAC](https://extranet.atlassian.com/display/MEDIA/Media+Viewer+for+Web)

### Building MediaViewer

First, install the required dependencies by running:

```
npm install
```

Available gulp tasks:

  - `npm run build`: Runs linter, tests and builds the project and example pages
  - `npm run compile`: As above, but does not run tests
  - `npm run spec`: Runs unit tests only
  - `npm run func`: Runs functional tests only
  - `npm run gulp watch`: Watching your files and enables Live Reload (currently slow)

If you want the output to be minified (for distribution):

```
npm run build --- --minify
```

More useful links:

- [Code repository](https://stash.atlassian.com/projects/DV/repos/dt-fileviewer/browse)
- [Continuous Ingegration (Bamboo)](https://engservices-bamboo.internal.atlassian.com/browse/MEDIA-FVW)
- [Issue Tracking (JIRA)](https://jira.atlassian.com/browse/FIL/component/32993/?selectedTab=com.atlassian.jira.jira-projects-plugin:component-summary-panel)

## Using plugins in MediaViewer

See the example pages. They make use of the _MiniMode_ plugin.

## Running the examples

This is the best way to understand how MediaViewer works and how can it be integrated. Just make sure the project is built and start a local server webserver:

```
npm install && npm run build
cd examples
python -m SimpleHTTPServer 8080
```

Now just point your browser to [http://localhost:8080/bare_page/](http://localhost:8080/bare_page/)


## Builds & Continuous Integration

The build agents runs the following task:

```
BROWSERSTACK_USERNAME=X BROWSERSTACK_ACCESS_KEY=Y npm run ci-all
```

You can retrieve the required credentials from our shared 1Password Vault.

## Publishing New Releases

Publishing a new release is a two-step process.

1. Cut a release 

    To cut a release you'll have to do three things
   
    - Update the `CHANGELOG.md` file
    - Run `git tag -a "vX.Y.Z"`
      **NOTE**: Make sure to specify the `-a` option and have a valid semantic version.
    - Push your changes to a branch

1. Deploy the release via Bamboo

    - New releases of Media Viewer need to be [published to npm using Bamboo](https://engservices-bamboo.internal.atlassian.com/browse/MEDIA-FVW).
    - Wait for the build for your branch to succeed first
    - Then create a new release from that build and deploy it to "Production"
    - When this is successful, you're done