define('cp/confluence/async-module-backend', [
    "jquery",
    "ajs"
], function (
    $,
    AJS
) {
    'use strict';

    var WRM_MAPPING = {
        'pdf-viewer': 'wr!com.atlassian.confluence.plugins.confluence-previews:confluence-previews-pdf'
    };

    var WORKER_JS_RESOURCE_NAME = 'com.atlassian.confluence.plugins.confluence-previews:confluence-previews-pdf-worker';

    var _getStaticPathForFile = function (pathName) {
        var staticPrefix = AJS.Meta.get("static-resource-url-prefix");
        return staticPrefix + "/download/resources/" + WORKER_JS_RESOURCE_NAME + "/" + pathName;
    };

    function getPdfConfig() {
        var dfd = new $.Deferred();
        $.ajax({
            url: AJS.contextPath() + "/rest/webResources/1.0/resources",
            type: "POST",
            contentType: "application/json",
            dataType: "json",
            data: JSON.stringify({
                r: [WORKER_JS_RESOURCE_NAME],
                c: [], xc: [], xr: []
            })
        }).done(function (data) {
            var workerSrc;
            for (var i in data.resources) {
                var url = data.resources[i].url;
                if (url && url.indexOf(WORKER_JS_RESOURCE_NAME) !== -1 ) {
                    workerSrc = url;
                    break;
                }
            }
            if (workerSrc) {
                var cMapUrl = _getStaticPathForFile('bcmaps/');
                dfd.resolve({
                    workerSrc: workerSrc,
                    cMapUrl: cMapUrl
                });
            } else {
                dfd.reject();
            }
        }).fail(dfd.reject.bind(dfd));
        return dfd.promise();
    }

    /**
     * Proxies requests for modules to WRM.
     * @param {string} templateUrl
     * @return {function}
     */
    return function (modulePath) {
        if (WRM_MAPPING[modulePath]) {
            return WRM.require(WRM_MAPPING[modulePath]);
        } else if (modulePath === "pdf-config") {
            return getPdfConfig();
        }
    };
});