define("cp/component/versions/versions-navigation-plugin", [
    "underscore",
    "MediaViewer",
    "cp/component/versions/version-title-view",
    "cp/component/versions/version-file-enricher",
    "cp/component/versions/version-message-view",
    "cp/component/versions/versions"
], function (
    _,
    FileViewer,
    VersionTitleView,
    VersionFileEnricher,
    VersionMessageView,
    Versions
) {
    "use strict";

    var versionsNavigationPlugin = function (mediaViewer) {

        if (!mediaViewer.getConfig().enableVersionNavigation) {
            return;
        }

        // replace default title with a title with version capability
        var titleView = mediaViewer.getView().fileTitleView;
        titleView.addPanelView("version-title", VersionTitleView);

        mediaViewer.getView().on("fv.fileChange", VersionFileEnricher.enrich);

        mediaViewer.getView().fileContentView.addLayerView('version-message', VersionMessageView);
    };

    versionsNavigationPlugin.showFileForPreviousVersion = function(fileViewer, file, version) {
        var enrichedFile = VersionFileEnricher.enrich(file);

        return enrichedFile.get('versions').fetchVersions().pipe(function() {
            var fileVersion = file.get('versions').findWhere({version: +version});
            if (!fileVersion) {
                return $.when(file);
            }
            return fileVersion.getFileVersion();
        }).pipe(function(versionedFile) {
            return mediaViewer.showFile(versionedFile);
        });
    };

    return versionsNavigationPlugin;
});

(function() {
    try {
        if (AJS.DarkFeatures.isEnabled('previews.versions')) {
            var VersionsNavigationPlugin = require('cp/component/versions/versions-navigation-plugin');
            var MediaViewer = require('MediaViewer');
            MediaViewer.registerPlugin('versionNavigation', VersionsNavigationPlugin);
        }
    } catch (err) {
        // Do nothing. We expect this to fail in the context of requirejs/karma by work with almond.
    }
}());
