define("cp/component/versions/version-title-view",
    [
        "backbone",
        "MediaViewer",
        "cp/component/versions/version-navigation-dialog-view",
        "core/template-store-singleton"
    ],
    function(
        Backbone,
        FileViewer,
        VersionNavigationDialogView,
        templateStore
    ) {
        "use strict";
        var iconUtils = FileViewer.require("util/icon-utils");
        var VersionTitleView = Backbone.View.extend({

            initialize: function (options) {
                this._mediaViewer = options.mediaViewer;
                this.options = options;
            },

            render: function() {
                var model = this._mediaViewer.getCurrentFile();
                if (!model) {
                    return this;
                }

                // for remote files, fallback to title with no version
                if (model.get("version") && model.get("id")) {
                    this.$el.html(templateStore.get("Versions.versionTitle")({
                        title: model.get("title"),
                        version: model.get("version"),
                        iconClass: iconUtils.getCssClass(model.get("type")),
                        isCurrent: model.isLatestVersion()
                    }));

                    this.versionsNavigationDialog = new VersionNavigationDialogView({
                        $btnTrigger: this.$(".cp-title"),
                        mediaViewer: this._mediaViewer
                    });
                } else {
                    var iconClass = iconUtils.getCssClass(model.get("type"));
                    var title = "<span>" + model.get("title") + "</span>";
                    var tpl = "<span class='" + iconClass + " size-24 cp-file-icon'></span>" + title;
                    this.$el.html(tpl);
                }

                return this;
            },

            teardown: function () {
                if (this.versionsNavigationDialog) {
                    this.versionsNavigationDialog.teardown();
                    this.versionsNavigationDialog = undefined;
                }
            }
        });

        return VersionTitleView;
    });