define(
    "cp/component/utils/editor-view",
    [
        "backbone",
        "underscore",
        "jquery",
        "cp/component/utils/editor",
        "cp/component/utils/editor-utils"
    ],
    function(
        Backbone,
        _,
        $,
        Editor,
        EditorUtils
        ) {

        "use strict";

        var EditorView = Backbone.View.extend({

            initialize: function(opts) {
                this.editorSetup = opts.editorSetup;
                this.preActivate = opts.preActivate;
                this.preInitialise = opts.preInitialise;
                this.postInitialise = opts.postInitialise;
                this.container = opts.container;
                this.saveHandler = opts.saveHandler;
                this.cancelHandler = opts.cancelHandler;
                this.postDeactivate = opts.postDeactivate;
                this.content = opts.content;
                this.errorCallback = opts.error;
                this.restoreCallback = opts.restoreCallback;
                this.successCallback = opts.success;
                this._mediaViewer = opts.mediaViewer;

                this.editorSetup && this.editorSetup();
            },

            render: function() {
                Editor.init({
                    preActivate: this.preActivate,
                    preInitialise: this.preInitialise,
                    postInitialise: this.postInitialise,
                    container: this.container,
                    form: this.container.find('form.aui'),
                    saveHandler: this.saveHandler,
                    cancelHandler: this.cancelHandler,
                    fetchContent: function () {
                        var responseDeferred = new $.Deferred();
                        responseDeferred.resolve({editorContent: this.content});
                        return responseDeferred;
                    }.bind(this),
                    closeAnyExistingEditor: true,
                    postDeactivate: this.postDeactivate,
                    _mediaViewer: this._mediaViewer
                }).fail(function() {
                    this.errorCallback();
                }.bind(this));

                return this;
            },

            getContent: function() {
                return Editor.getContent();
            },

            remove: function() {
                Editor.remove();
                return this;
            },

            checkIfOpen: function() {
                return EditorUtils.confirmProcess();
            }
        });

        return EditorView;
    }
);