define('cp/component/share-button/share-button-plugin', [
    'jquery',
    'ajs',
    'backbone',
    'MediaViewer',
    'core/template-store-singleton',
    'confluence/share-page/service/share-page'
], function ($,
             AJS,
             Backbone,
             FileViewer,
             templateStore,
             SharePage) {
    'use strict';

    var currentDialog = null;

    var ShareButtonView = Backbone.View.extend({
        tagName: 'span',

        initialize: function (options) {
            this._mediaViewer = options.mediaViewer;
        },

        teardown: function () {
            if (currentDialog) {
                currentDialog.remove();
                currentDialog = null;
            }
        },

        render: function () {
            var that = this;
            this.$el.html(templateStore.get('controlShareButton')());
            if ($.fn.tooltip) {
                this.$('a').tooltip({gravity: 'n'});
            }
            setTimeout(function () {
                that.postRender();
            }, 0);

            return this;
        },
        postRender: function () {
            var that = this;

            var selector = "#cp-control-panel-share";
            var $trigger = $(selector);
            SharePage.initDialog(selector, "sharePreviewPopup", {}, {
                heading: AJS.I18n.getText('share.dialog.heading.file'),
                notePlaceholder: AJS.I18n.getText('share.dialog.message.placeholder.file'),
                link: function () {
                    return window.location;
                },
                entityId: function () {
                    return that._mediaViewer.getCurrentFile().get('id')
                },
                copyOption: 'share',
                shareType: 'attachment',
                contentType: 'attachment',
                errorText: AJS.I18n.getText('share.dialog.error'),
                beforeLoad: function () {
                    $trigger.find('.aui-icon').css('visibility', 'hidden'); // hide current icon
                    $trigger.removeClass('cp-share-icon');
                    $trigger.parent().spin({top: '17px', left: '17px', color: 'white'});
                },
                afterLoad: function () {
                    $trigger.find('.aui-icon').css('visibility', 'visible'); // show current icon
                    $trigger.parent().spinStop();
                    $trigger.addClass('cp-share-icon');
                },
                onShow: function ($contents) {
                    that._mediaViewer.getView().lockNavigationKeys();
                    $contents.attr('data-fv-allow-focus', 1);
                    currentDialog = $trigger.data('dialog');
                },
                onHide: function () {
                    that._mediaViewer.getView().unlockNavigationKeys();
                }
            });
        }
    });

    var shareButtonPlugin = function (mediaViewer) {
        if (!mediaViewer.getConfig().enableShareButton) {
            return;
        }
        mediaViewer.getView().fileControlsView.addLayerView('shareButton', ShareButtonView, {
            weight: 2,
            predicate: function (mediaViewer) {
                return !mediaViewer.getCurrentFile().get('isRemoteLink');
            }
        });
    };

    return shareButtonPlugin;
});

(function () {
    var ShareButtonPlugin = require('cp/component/share-button/share-button-plugin');
    var MediaViewer = require('MediaViewer');
    MediaViewer.registerPlugin('sharebutton', ShareButtonPlugin);
})();
