define('cp/component/feature-discovery/discovery-dialog', [
    'jquery',
    'underscore',
    'MediaViewer',
    'core/template-store-singleton',
    'aui/inline-dialog2'
], function (
  $,
  _,
  FileViewer,
  templateStore
) {
    'use strict';
    var shimEvent = function (context, name) {
        return function () {
            context.trigger(name, arguments);
        }
    };

    var DiscoveryDialog = function (opts) {
        this.$anchor = $(opts.anchor);
        this.$appendTo = $(opts.appendTo);
        this.key = opts.key;
        this.text = opts.text;
        this.dialog = null;

        this.$anchor.attr({
            'aria-controls': 'cp-feature-discovery',
            'data-aui-trigger': true
        });

        var $discoveryDialog = $(templateStore.get("FeatureDiscovery.featureDiscovery")({
            text: this.text
        }));

        $discoveryDialog.find(".cp-feature-discovery-confirm").click(function (e) {
            this.dismiss(true);
            e.preventDefault();
        }.bind(this));

        var discoveryDialog = $discoveryDialog[0];
        this.$appendTo.append(discoveryDialog);
        skate.init(discoveryDialog);
        discoveryDialog.show();

        this.dialog = discoveryDialog;

        _.extend(this, Backbone.Events);

        this.dialog.addEventListener('aui-layer-hide', shimEvent(this, "hide"));
        this.dialog.addEventListener('aui-layer-show', shimEvent(this, "show"));

        return this;

    };

    DiscoveryDialog.prototype.is = function(key) {
        return this.key === key;
    };

    DiscoveryDialog.prototype.on = function(event, callback) {
        var eventName = event;
        if (event === 'hide') {
            eventName = 'aui-layer-hide';
        } else  if (event === 'show') {
            eventName = 'aui-layer-show';
        }
        this.dialog.addEventListener(eventName, callback);
    };

    DiscoveryDialog.prototype.dismiss = function(shouldNotify) {
        this.dialog.hide();
        this.dialog.remove();
        shouldNotify && this.trigger("user-dismissed-dialog", this.key);
    };

    return DiscoveryDialog;
});