define(
    "cp/component/annotation/pin-view",
    [
        "backbone",
        "jquery",
        "cp/component/annotation/comment",
        "cp/component/utils/editor-utils"
    ],
    function(
        Backbone,
        $,
        Comment,
        EditorUtils
        ) {

        "use strict";

        var PinView = Backbone.View.extend({
            model: Comment,

            tagName: "span",

            className: "cp-icon cp-active-annotation",

            events: {
                "click": "clickPin"
            },

            clickPin: function() {
                if(EditorUtils.confirmProcess()) {
                    //close panel if we're clicking on the same pin again
                    var sidebarView = this._mediaViewer.getView().fileSidebarView;
                    if (this.model.get("selected") && sidebarView.isPanelInitialized("annotations")) {
                        this.closeSidebar();
                    } else {
                        this.showPin();
                        this._mediaViewer.trigger("cp.close-editor");
                    }
                }
            },

            closeSidebar: function() {
                this.collection.setSelected();
                this._mediaViewer.trigger("cp.close-editor");
                this._mediaViewer.getView().fileSidebarView.teardownPanel();
            },

            showPin: function() {
                this.collection.setSelected(this.model);
                this.collection.trigger("pinSelected");
                this._mediaViewer._fileState.trigger('cp.showAnnotations');
            },

            initialize: function(props) {
                this._mediaViewer = props.mediaViewer;
                this.calculatePosition = props.calculatePosition;
                this.listenTo(this.model, "sync", this.render);
                this.listenTo(this.model, "change:resolved", this.setResolved);
                this.listenTo(this.model, "change:selected", this.setAnimate);
            },

            setResolved: function () {
                var resolved = this.model.get("resolved");
                this.$el.toggleClass("resolved", resolved);
            },

            setSelected: function() {
                var selected = this.model.get("selected");
                this.$el.toggleClass("selected", selected);
            },

            setAnimate: function() {
                var selected = this.model.get("selected");
                this.setSelected();

                this.$el.toggleClass("animate", selected);
            },

            setPosition: function() {
                var position;
                if (this.calculatePosition) {
                    position = this.calculatePosition(this.model.toJSON());
                } else {
                    var modelPosition = this.model.get("position");
                    var percX = modelPosition[0] * 100;
                    var percY = modelPosition[1] * 100;
                    position =  {x: percX + "%", y: percY + "%"};
                }

                this.$el.css("top", position.y);
                this.$el.css("left", position.x);
            },

            render: function() {
                this.$el.attr("data-comment-id", this.model.get("id"));
                this.setPosition();
                this.setResolved();
                this.setSelected();
                return this;
            }
        });

        return PinView;

    });

