define(
    "cp/component/annotation/add-annotation-view",
    [
        "backbone",
        "underscore",
        "jquery",
        "ajs",
        "cp/component/utils/editor-view",
        'cp/component/utils/editor-utils',
        "MediaViewer",
        "core/template-store-singleton"
    ],
    function (
        Backbone,
        _,
        $,
        AJS,
        EditorView,
        EditorUtils,
        FileViewer,
        templateStore
    ) {

        "use strict";
        var fileChangeMode = FileViewer.prototype.changeMode;
        var AddAnnotationView = Backbone.View.extend({
            tagName: "div",

            id: "cp-add-annotation",

            events: {},

            initialize: function(attrs) {
                this._mediaViewer = attrs.mediaViewer;
                this._annotationView = attrs.annotationView;
                this.currentUser = {
                    name: AJS.Meta.get("current-user-fullname"),
                    avatar: AJS.Meta.get("current-user-avatar-uri-reference"),
                    profile: AJS.contextPath() + "/display/~" + AJS.Meta.get("remote-user")
                };

                this._annotation = attrs.annotation;

                this.listenTo(this._mediaViewer._fileState, "cp.hideAnnotations", this.clearAnnotation);
                this.listenTo(this._mediaViewer, "fv.close", this.clearAnnotation);
                this.listenTo(this.collection, "pinSelected", this.teardown);
            },

            render: function() {
                this.editorView = this._annotationView._editorView = new EditorView({
                    editorSetup: function() {
                        this.$el.html(templateStore.get('Annotation.addAnnotation')({
                            author: this.currentUser
                        }));
                    }.bind(this),
                    container: this.$el,
                    saveHandler: _.bind(this.saveAnnotation, this),
                    cancelHandler: _.bind(this.cancelAnnotation, this),
                    content: "",
                    restoreCallback: _.bind(this.cancelAnnotation, this),
                    mediaViewer: this._mediaViewer
                });
                this.editorView.render();

                var _this = this;
                this._mediaViewer.changeMode = function() {
                    if (EditorUtils.confirmProcess()) {
                        _this.cancelAnnotation();
                        return fileChangeMode.apply(this, arguments);
                    }
                };

                return this;
            },

            cancelAnnotation: function(e) {
                e && e.preventDefault();
                this.removeNewAnnotation();
                this.collection.setSelected(this.collection.getCurrentOrNext());
            },

            removeNewAnnotation: function() {
                this.clearAnnotation();
                this._annotation.destroy();
                this.editorView && this.editorView.remove();
                this._mediaViewer.changeMode = fileChangeMode;
            },

            clearAnnotation: function() {
                this._mediaViewer.getView().$el
                  .find("#cp-file-control-annotate")
                  .draggable("option", "disabled", false);
            },

            saveAnnotation: function(e) {
                e && e.preventDefault();

                if(this.editorView.getContent() === "") {
                    this._generateError(AJS.I18n.getText('cp.annotations.save.empty'));
                    return;
                }

                this._annotation.set("editorFormat", this.editorView.getContent(), {silent: true});
                this._annotation.set("isNew", false);
                this._annotation.save();

                this.editorView && this.editorView.remove();
                this.clearAnnotation();
                AJS.trigger('analyticsEvent', {
                    name: 'confluence-spaces.previews.annotation.comment',
                    data: {
                        fileType: this._mediaViewer.getCurrentFile().get("type"),
                        attachmentId: this._mediaViewer.getCurrentFile().get("id")
                    }
                });
                this.collection.setSelected(this._annotation);
                this._mediaViewer.changeMode = fileChangeMode;
            },

            teardown: function() {
                if (this._annotation.isNew()) {
                    this.removeNewAnnotation();
                } else {
                    this.clearAnnotation();
                }
                return this;
            },

            _generateError: function(error) {
                $(".cp-error").empty();
                AJS.messages.warning(".cp-error", {
                    body: error
                });
            }
        });

        return AddAnnotationView;
    });
