define('confluence/page-hierarchy/util/is-error-type', [], function () {
    /**
     * Determines if we have encountered a certain type of error.
     * Because of the structure of the errors we are expecting, it makes certain assumptions.
     * If it finds the error in the list, it is deemed to be that kind of error, based on the possible
     * error states we get back from the server.
     *
     * A list of errors might be simultaneously any reasonable combination of the errors checked in the
     * usages of this method, and it is up to the caller to determine what to do with that information.
     *
     * @param {Array} errors Array of errors we have
     * @param {string} type @see usages
     * @returns {boolean} true iff it encounters {@link type} in the array
     * @see usages
     * @private
     */
    return function isErrorType(errors, type) {
        for (var i = 0; i < errors.length; i++) {
            if (errors[i].key === type) {
                return true;
            }
        }

        return false;
    }
});