define('confluence/page-hierarchy/util/get-error-pages', [], function () {
    /**
     * Get the page titles, ids, and urls from the list of errors we have
     * @param {object} state The state object that contains the errors
     * @param {string} errorName The name of the error that we are looking for
     * @returns {Array} of Pages from the errors
     * @private
     */
    return function getErrorPages(state, errorName) {
        var errors = state.getErrors();
        var pages = [];

        for (var i = 0; i < errors.length; i++) {
            var error = errors[i];
            var args = error.args;
            if (error.key === errorName && args && args.length) {
                pages.push({title: args[0], id: args[1], url: args[2]}); // original page name
            }
        }

        return pages;
    }
});