define('confluence/page-hierarchy/util/execute-if-function', [], function () {
    /**
     * If the supplied parameter is a function, it runs it with the remaining arguments passed
     * to the function itself.
     * @param {function} func The function to run if it is defined.
     * @returns {undefined}
     */
    return function executeIfFunction(func) {
        if (func && typeof func === 'function') {
            func.apply(undefined, Array.prototype.slice.call(arguments, 1));
        }
    }
});