/**
 * This is the source of truth.
 */
define('confluence/page-hierarchy/state/delete-state',
    [
        'ajs'
    ], function (AJS) {
        var DEFAULT_DELETE_HIERARCHY = false;
        // Triggered when the process is completely done and the user is done review any errors
        var FINISHED_EVENT = "page-hierarchy-plugin:delete-finished";
        // Triggered when the user clicks next after selecting to delete children
        var DELETE_HIERARCHY_EVENT = "page-hierarchy-plugin:delete-hierarchy";
        // Triggered when the user submits the delete hierarchy operation
        var DELETE_HIERARCHY_SUBMIT_EVENT = "page-hierarchy-plugin:delete-hierarchy-submit";
        // Triggered when the user hits back from the preview dialog
        var DELETE_HIERARCHY_BACK_EVENT = "page-hierarchy-plugin:delete-hierarchy-back";
        // Done the process but maybe there are errors, as opposed to FINISHED_EVENT
        var DELETE_HIERARCHY_DONE_EVENT = "page-hierarchy-plugin:delete-hierarchy-done";
        // Triggered when the user chooses to review the delete page errors
        var DELETE_HIERARCHY_VIEW_ERROR_EVENT = "page-hierarchy-plugin:delete-view-errors-event";
        // Triggered when the user chooses cancel on any dialog
        var DELETE_HIERARCHY_CANCEL_EVENT = "page-hierarchy-plugin:delete-cancel";
        // Triggered the delete cannot start because there is an error
        var DELETE_HIERARCHY_ERROR_EVENT = "page-hierarchy-plugin:delete-error";

        var ERROR_MESSAGES = {
            'notfound': AJS.I18n.getText("delete.page.hierarchy.error.notfound"),
            'title': AJS.I18n.getText("delete.page.hierarchy.error.title.all"),
            'description': AJS.I18n.getText("delete.page.hierarchy.error.description.all"),
            'title-some': AJS.I18n.getText("delete.page.hierarchy.error.title.some"),
            'unauthorized': AJS.I18n.getText("delete.page.hierarchy.error.unauthorized"),
            'view-failed': AJS.I18n.getText("delete.page.hierarchy.error.view.failed")
        };

        var options = {};
        var state = {};
        var errors = [];
        var warnings = [];
        var permissions = [];

        reset();

        function reset() {
            options = {
                deleteHierarchy: DEFAULT_DELETE_HIERARCHY,
                targetPageId: AJS.Meta.get('page-id')
            };
            state = {
                anyPagesDeleted: false,
                taskId: '',
                existingFlow: false,
                originalPageTitle: AJS.Meta.get('page-title')
            };
            errors = [];
            warnings = [];
            permissions = [];
        }

        function getOptions() {
            return options;
        }

        function getState() {
            return state;
        }

        function getErrors() {
            return errors;
        }

        function setErrors(err) {
            errors = err;
        }

        function clearErrors() {
            errors = [];
            warnings = [];
        }

        function getWarnings() {
            return warnings;
        }

        function setWarnings(warn) {
            warnings = warn;
        }

        function getPermissions() {
            return permissions;
        }

        function setPermissions(perms) {
            permissions = perms;
        }

        function setDeleteHierarchy(value) {
            options.deleteHierarchy = !!value;
        }

        function setTargetIds(ids) {
            options.targetIds = ids;
        }

        function setTaskId(taskId) {
            state.taskId = taskId;
        }

        function setExistingFlow(isExistingFlow) {
            state.existingFlow = isExistingFlow;
        }

        function setOriginalPageTitle(originalPageTitle) {
            state.originalPageTitle = originalPageTitle;
        }

        function setNumPagesDeleted(value) {
            state.numPagesDeleted = value;
        }

        return {
            FINISHED_EVENT: FINISHED_EVENT,
            DELETE_HIERARCHY_EVENT: DELETE_HIERARCHY_EVENT,
            DELETE_HIERARCHY_SUBMIT_EVENT: DELETE_HIERARCHY_SUBMIT_EVENT,
            DELETE_HIERARCHY_BACK_EVENT: DELETE_HIERARCHY_BACK_EVENT,
            DELETE_HIERARCHY_DONE_EVENT: DELETE_HIERARCHY_DONE_EVENT,
            DELETE_HIERARCHY_VIEW_ERROR_EVENT: DELETE_HIERARCHY_VIEW_ERROR_EVENT,
            DELETE_HIERARCHY_CANCEL_EVENT: DELETE_HIERARCHY_CANCEL_EVENT,
            DELETE_HIERARCHY_ERROR_EVENT: DELETE_HIERARCHY_ERROR_EVENT,
            ERROR_MESSAGES: ERROR_MESSAGES,
            getOptions: getOptions,
            getState: getState,
            getErrors: getErrors,
            setErrors: setErrors,
            getWarnings: getWarnings,
            setWarnings: setWarnings,
            getPermissions: getPermissions,
            setPermissions: setPermissions,
            setDeleteHierarchy: setDeleteHierarchy,
            setTargetIds : setTargetIds,
            setOriginalPageTitle: setOriginalPageTitle,
            setNumPagesDeleted: setNumPagesDeleted,
            setTaskId: setTaskId,
            setExistingFlow: setExistingFlow,
            reset: reset,
            clearErrors: clearErrors
        };

    });