define('confluence/page-hierarchy/service/delete-navigator', [
    'ajs',
    'confluence/page-hierarchy/fetch/fetch-page-info'
], function (AJS,
             fetchPageInfo) {
    var PAGES_PATH = '/collector/pages.action?key=<spaceKey>';
    var PARENT_PATH = '/pages/viewpage.action?pageId=<pageId>';

    /**
     * Create the url to follow with the additional hash information
     * @param {string} url Original URL
     * @param {string} taskId The Long Running Task Id
     * @returns {string} The URL with the hash parameters
     * @private
     */
    function _createPath(url, taskId) {
        var currentTitle = AJS.Meta.get('page-title');
        return url + '#delete-complete&' + taskId + '&' + encodeURIComponent(currentTitle);
    }

    /**
     * Navigates to the pages collector page with the hash parameters
     * @param {string} taskId The Long Running Task Id
     * @returns {undefined}
     * @private
     */
    function _navigateToPages(taskId) {
        var spaceKey = AJS.Meta.get('space-key');
        var url = AJS.contextPath() + PAGES_PATH.replace('<spaceKey>', spaceKey);
        window.location = _createPath(url, taskId);
    }

    /**
     * Navigates to the parent of this page. If there is no parent then it navigates
     * to the pages collector page. In both cases it adds additional information to the url
     * @param {string} taskId The Long Running Task Id
     * @returns {undefined}
     */
    function navigateToParent(taskId) {
        var parentPageId = AJS.Meta.get('parent-page-id');
        if (!parentPageId) {
            return _navigateToPages(taskId);
        }
        fetchPageInfo(parentPageId).done(function () {
            var url = AJS.contextPath() + PARENT_PATH.replace('<pageId>', parentPageId);
            window.location = _createPath(url, taskId);
        }).fail(function () {
            _navigateToPages(taskId);
        });
    }

    return {
        navigateToParent: navigateToParent
    }
});