define('confluence/page-hierarchy/fetch/fetch-page-info', [
    'ajs'
], function (AJS) {
    var ENDPOINT = '/rest/api/content/<pageId>';

    var OLDER_VERSION_ENDPOINT = '/rest/api/content/<pageId>?version=<olderVersionId>&status=current';

    /**
     * Fetches the details of a page from REST
     * @param {number} pageId The page id
     * @param {number} latestPageId the latest page id
     * @returns {jQuery.Deferred} with the results
     */
    function fetchPageInfo(pageId, latestPageId) {
        var deferred = AJS.$.Deferred();
        var olderPageVersion = AJS.Meta.get('page-version');
        var actualPageId = pageId;

        if (latestPageId && (latestPageId !== pageId)) {
            ENDPOINT = OLDER_VERSION_ENDPOINT;
            actualPageId = latestPageId;
        }

        AJS.$.ajax({
            url: AJS.contextPath() + ENDPOINT.replace('<pageId>', actualPageId).replace('<olderVersionId>', olderPageVersion)
        }).done(function (data) {
            deferred.resolve(data);
        }).fail(function (data) {
            deferred.reject(data);
        });

        return deferred.promise();
    }

    return fetchPageInfo;
});