define('confluence/page-hierarchy/fetch/fetch-space-permissions', [
    'ajs'
], function (AJS) {
    var ENDPOINT = '/rest/page-hierarchy/internal/spacePermissions/<spaceKey>';

    /**
     * Returns an object representing the space permissions that the currently-logged-in user
     * does and does not have.
     * ie. {
     *     pages: true, // can add pages
     *     restrictions: false, // cannot add restrictions
     *     sysAdmin: false, // is not a sys admin
     * }
     * @param {string} spaceKey Space Key to check
     * @returns {jQuery.Deferred} with the results
     */
    function fetchSpacePermissions(spaceKey) {
        var deferred = AJS.$.Deferred();

        AJS.$.ajax({
            url: AJS.contextPath() + ENDPOINT.replace('<spaceKey>', spaceKey)
        }).done(function (data) {
            deferred.resolve(data);
        }).fail(function () {
            deferred.reject();
        });

        return deferred.promise();
    }

    return fetchSpacePermissions;
});