define('confluence/page-hierarchy/dialog/delete-error-dialog', [
    'ajs',
    'confluence/page-hierarchy/service/dialog-service',
    'confluence/page-hierarchy/state/delete-state',
    'confluence/page-hierarchy/util/get-error-pages'
], function (AJS,
             DialogService,
             state,
             getErrorPages) {
    var NAME = 'delete-error-dialog';
    var SELECTOR = '#page-hierarchy-error-dialog';
    var CLOSE_SELECTOR = '#close';
    var ERROR_DELETE_PAGE = 'ERROR_DELETE_PAGE';

    var TEMPLATE_NAME = 'errorDialog';

    var dialog = DialogService.get(NAME, {
        selector: SELECTOR,
        templateName: TEMPLATE_NAME,
        templateParameters: {
            pages: function () {
                return getErrorPages(state, ERROR_DELETE_PAGE);
            },
            type: 'delete'
        },
        onShow: _run
    });

    /**
     * Main method to setup the dialog
     * @returns {undefined}
     * @private
     */
    function _run() {
        var $close = dialog.$element.find(CLOSE_SELECTOR);

        $close.on('click', function () {
            AJS.trigger(state.FINISHED_EVENT);
        });
    }

    return dialog;
});