define('confluence/ob/modules/tutorial/view-page/base-sequence', [
    'jquery',
    'underscore',
    'confluence/ob/common/promise',
    'aui/inline-dialog2'
], function($, _, Promise) {
    'use strict';

    function baseSequence(options) {
        this.options = _.extend({}, options);
        this._resolve = null;
    }

    /**
     * This function will be called first, It's useful for checking condition before execute function is called.
     * @param container
     * @param analytics
     * @returns {*}
     */
    baseSequence.prototype.init = function(container, analytics) {
        if (!this.isViewingPage()) {
            return Promise($.noop);
        }

        return Promise(_.bind(this.execute, this));
    };

    /**
     * Check if user is viewing a page or blog
     * @returns {boolean}
     */
    baseSequence.prototype.isViewingPage = function() {
        return !!$('#main-content.wiki-content').length;
    };

    /**
     * This function is the main function, all logic of step should put in here
     * @param resolve
     */
    baseSequence.prototype.execute = function(resolve) {
        this._resolve = resolve;
        var isTriggerExisted = !!$(this.options.trigger).length;

        if (isTriggerExisted) {
            this.showPopup.call(this);
        } else {
            resolve();
        }
    };

    /**
     * Show an popup (inline-dialog) base on the parameter of current instance
     */
    baseSequence.prototype.showPopup = function() {
        $(this.options.trigger).attr({
            'aria-controls': this.options.id
        });
        var $el = $(Confluence.Templates.OB.tourPopup({
            data: this.options.data
        }));

        $el.appendTo('body');

        // AUI 5.7 bug, setTimeout should be executed to make sure skate is ready.
        var timeout = ($("html").attr("webdriver") === "true") ? 1000 : 0; // webdriver takes 1s to ensure skate is ready
        setTimeout(_.bind(function() {
            if ($el[0].show) {
                $el[0].show();
            } else {
                $el[0].open = true;
            }
            this.afterShowPopup($el);
        }, this), timeout);
    };

    /**
     * This function will be called after popup shown successful
     * @param $el
     */
    baseSequence.prototype.afterShowPopup = function($el) {
        $el.on('click', '.next', _.bind(this.onNextClicked, this, $el[0]));
    };

    /**
     * When Next button inside popup is clicked
     * @param popup
     * @param event
     */
    baseSequence.prototype.onNextClicked = function(popup, event) {
        popup.remove();
        this._resolve && this._resolve();
    };

    return baseSequence;
});