/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.efi;

import com.atlassian.confluence.efi.OnboardingManager;
import com.atlassian.confluence.efi.OnboardingUtils;
import com.atlassian.confluence.efi.store.GlobalStorageService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.tenancy.api.event.TenantArrivedEvent;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class OnboardingManagerImpl
implements OnboardingManager {
    private static final String DEMO_SPACE_KEY = "ds";
    private final EventPublisher eventPublisher;
    private final GlobalStorageService globalStorageService;
    private final SpaceManager spaceManager;
    private String pluginInstalledDateInMillis;

    public OnboardingManagerImpl(GlobalStorageService globalStorageService, EventPublisher eventPublisher, SpaceManager spaceManager) {
        this.globalStorageService = globalStorageService;
        this.eventPublisher = eventPublisher;
        this.spaceManager = spaceManager;
    }

    @Override
    @EventListener
    public void onTenantArrived(TenantArrivedEvent e) {
        if (this.getPluginInstalledDateInMillis() == Long.MIN_VALUE) {
            this.pluginInstalledDateInMillis = String.valueOf(DateTime.now().getMillis());
            this.globalStorageService.set("plugin-installed-date-in-millis", this.pluginInstalledDateInMillis);
        }
    }

    @Override
    public boolean isFirstSpaceCreated() {
        return StringUtils.equalsIgnoreCase((String)"true", (String)this.globalStorageService.get(OnboardingUtils.METADATA_IS_FIRST_SPACE_CREATED));
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @Override
    public long getPluginInstalledDateInMillis() {
        this.pluginInstalledDateInMillis = StringUtils.isEmpty((String)this.pluginInstalledDateInMillis) ? this.globalStorageService.get("plugin-installed-date-in-millis") : this.pluginInstalledDateInMillis;
        return StringUtils.isEmpty((String)this.pluginInstalledDateInMillis) ? Long.MIN_VALUE : Long.valueOf(this.pluginInstalledDateInMillis);
    }
}

