define('confluence/ob/common/storage/server-storage', ['jquery', 'ajs'], function ($, AJS) {
    var ServerStorage = {};

    ServerStorage.get = function(key) {
        return $.ajax({
            url: AJS.contextPath() + "/rest/onboarding/1/store",
            type: "GET",
            contentType: "application/json",
            data: {key: key}
        }).pipe(function(resp) {
            return resp.value;
        });
    };

    ServerStorage.set = function(key, valueStr) {
        return $.ajax({
            url: AJS.contextPath() + "/rest/onboarding/1/store",
            type: "PUT",
            contentType: "application/json",
            data: JSON.stringify({
                key: key,
                value: valueStr
            })
        });
    };

    ServerStorage.setTeam = function(teamId) {
        return $.ajax({
            url: AJS.contextPath() + "/rest/onboarding/1/store/team?id=" + teamId,
            type: "PUT",
            contentType: "application/json"
        });
    };

    ServerStorage.remove = function(key) {
        return $.ajax({
            url: AJS.contextPath() + "/rest/onboarding/1/store",
            type: "DELETE",
            contentType: "application/json",
            data: {
                key: key
            }
        });
    };

    // Note: this method does not yet support ordering of posts when they occur really quickly on the same key
    ServerStorage.setGlobal = function(key, valueStr) {
        return $.ajax({
            url: AJS.contextPath() + "/rest/onboarding/1/store/global",
            type: "PUT",
            contentType: "application/json",
            data: JSON.stringify({
                key: key,
                value: valueStr
            })
        });
    };

    ServerStorage.getGlobal = function(key) {
        return $.ajax({
            url: AJS.contextPath() + "/rest/onboarding/1/store/global",
            type: "GET",
            contentType: "application/json",
            data: {
                key: key
            }
        });
    };

    ServerStorage.removeGlobal = function(key) {
        return $.ajax({
            url: AJS.contextPath + "/rest/onboarding/1/store/global",
            type: "DELETE",
            contentType: "application/json",
            data: {
                key: key
            }
        });
    };

    return ServerStorage;
});
