define('confluence/ob/modules/tutorial/view-page/sidebar-sequence', [
    'jquery',
    'underscore',
    'ajs',
    'confluence/ob/modules/tutorial/view-page/base-sequence'
], function ($, _, AJS, BaseSequence) {
    'use strict';

    var _interval = null;
    var id = 'onboarding-tour-sidebar-page-structure';
    function isSidebarCollapsed() {
        return $('.ia-fixed-sidebar').hasClass('collapsed') || ($('.aui-sidebar').attr('aria-expanded') === 'false');
    }

    function addBlueprintLabel() {
        var pageId = AJS.Meta.get('page-id');
        var selectedBlueprint = sessionStorage.getItem('selected-blueprint');
        if (selectedBlueprint) {
            sessionStorage.removeItem('selected-blueprint');

            var blueprintLabel = selectedBlueprint.split('-')[0];
            var labelId = new Date().getTime();
            return $.ajax({
                type: 'POST',
                dataType: 'json',
                contentType: 'application/json',
                data: JSON.stringify([{
                    name: blueprintLabel,
                    id: labelId
                }]),
                url: AJS.contextPath() + '/rest/ui/1.0/content/' + pageId + '/labels'
            });
        }
    }

    function sidebarSequence() {}

    sidebarSequence.prototype = new BaseSequence({
        id: id,
        trigger: '.plugin_pagetree_current a',
        data: {
            id: id,
            alignment: 'bottom left',
            text: AJS.I18n.getText('onboarding.sequence.viewPage.sidebar.text'),
            buttonClass: 'aui-button-primary',
            buttonText: AJS.I18n.getText('onboarding.editor.popup.button.next'),
            extraClass: 'view-page'
        }
    });

    sidebarSequence.prototype.execute = function(resolve) {
        addBlueprintLabel();

        if (isSidebarCollapsed()) {
            Confluence.Sidebar.toggle();
        }

        this._resolve = resolve;

        if ($(this.options.trigger).length) {
            this.showPopup();
        } else {
            // Make sure page tree loaded before processing
            AJS.bind('pagetree-children-loaded', _.bind(this.showPopup, this));
        }
    };

    sidebarSequence.prototype.afterShowPopup = function($popup) {
        BaseSequence.prototype.afterShowPopup.call(this, $popup);

        // Handler the case that user active quick-edit page.
        AJS.bind('rte-quick-edit-ready', function() {
            // check if sidebar is still visible, we don't want to hide if editor is a inline-comment
            var sidebarVisible = $('.ia-splitter-left, .aui-sidebar').is(':visible');
            if (!sidebarVisible) {
                $popup[0].remove();
            }
        });

        var checkingSidebar = function() {
            var isPopupVisible = $popup[0].isVisible();
            if (isSidebarCollapsed()) {
                isPopupVisible && $popup[0].hide();
            } else {
                !isPopupVisible && $popup[0].show();
            }
        };

        _interval = setInterval(checkingSidebar, 500);
    };

    sidebarSequence.prototype.onNextClicked = function(popup, event) {
        clearInterval(_interval);
        BaseSequence.prototype.onNextClicked.call(this, popup, event);
    };

    return sidebarSequence;
});