define('confluence/ob/modules/tutorial/comment/comment-highlight-sequence', [
    'jquery',
    'confluence/ob/modules/tutorial/view-page/base-sequence'
], function($, BaseSequence) {
    'use strict';

    var id = 'onboarding-comment-highligh';

    function commentSequence() {}

    commentSequence.prototype = new BaseSequence({
        id: id,
        trigger: '#comments-section',
        data: {
            id: id,
            alignment: 'top center',
            text: AJS.I18n.getText('onboarding.sequence.comment.hightligh.text'),
            buttonClass: 'aui-button-primary',
            buttonText: AJS.I18n.getText('onboarding.sequence.comment.button.next'),
            extraClass: 'onboarding-comment-highlight'
        }
    });

    commentSequence.prototype.execute = function(resolve) {
        var $commentSection = $('#comments-section');

        // append the backdrop to body
        $(Confluence.Templates.OB.commentHighlight()).appendTo('body');

        hideExistingComments();

        $commentSection.addClass('onboarding-highlight');
        scrollTo($commentSection);

        BaseSequence.prototype.execute.call(this, resolve);

        function scrollTo($ele) {
            $('html, body').animate({
                scrollTop: $ele.offset().top
            }, 1000);
        }
    };

    commentSequence.prototype.afterShowPopup = function($popup) {
        BaseSequence.prototype.afterShowPopup.call(this, $popup);

        // Handler the case that user active quick-edit page.
        AJS.bind('rte-quick-edit-ready', function () {
            // hide popup and backdrop
            $('#onboarding-comment-backdrop').remove();
            $popup[0].remove();

            // remove the fake comment div
            showExistingComments(true);
        });

        var $commentPrompt = $('div.quick-comment-prompt');

        // clone the comment element and hide the original one to avoid click action by quick editor
        $commentPrompt.clone().attr('class', 'onboarding-quick-comment-prompt').insertAfter($commentPrompt);
        $commentPrompt.hide();
    };

    commentSequence.prototype.onNextClicked = function(popup, event) {
        $('#onboarding-comment-backdrop').remove();
        $('#comments-section').removeClass("onboarding-highlight");

        BaseSequence.prototype.onNextClicked.call(this, popup, event);

        // hide popup and backdrop
        showExistingComments();
    };

    function hideExistingComments() {
        $('.section-header').hide();
        $('#page-comments').hide();
    }

    function showExistingComments(rteActive) {
        $('.section-header').show();
        $('#page-comments').show();

        $('div.onboarding-quick-comment-prompt').remove();

        if(!rteActive)
            $('div.quick-comment-prompt').show();
    }

    return commentSequence;
});