define('confluence/ob/modules/tutorial/comment/comment-demo-sequence', [
    'jquery',
    'confluence/ob/modules/tutorial/view-page/base-sequence',
    'confluence/ob/common/page-utils'
], function($, BaseSequence, PageUtils) {
    'use strict';

    var id = 'onboarding-comment-demo';

    function commentDemoSequence() {}

    commentDemoSequence.prototype = new BaseSequence({
        id: id,
        trigger: '#comments-section-fake',
        data : {
            id: id,
            alignment: 'top center',
            text: AJS.I18n.getText('onboarding.sequence.comment.added.text'),
            buttonClass: 'aui-button-primary',
            buttonText: AJS.I18n.getText('onboarding.sequence.comment.button.done'),
            extraClass: 'onboarding-comment-highlight'
        }
    });

    commentDemoSequence.prototype.execute = function(resolve) {
        var $fakeStorageComment = $(Confluence.Templates.OB.fakeStorageComment({
            userKey: AJS.Meta.get('remote-user-key')
        }));

        var payload = {
            "representation": "storage",
            "value": $fakeStorageComment.html()
        };

        PageUtils.showLoadingIndicator();

        // use confluence API to convert from storage format to view format
        $.ajax({
            url: AJS.contextPath() + '/rest/api/contentbody/convert/view',
            type: 'POST',
            contentType: "application/json",
            dataType: "json",
            data: JSON.stringify(payload)
        }).done(_.bind(onConvertSuccessful, this))
                .fail(resolve)
                .always(PageUtils.hideLoadingIndicator);

        $(Confluence.Templates.OB.commentHighlight()).appendTo('body');

        function createFakeComment(data) {
            var $content = $(Confluence.Templates.Comments.displayComment({
                highlight: false,
                firstReply: true,
                commenter: {
                    userName: AJS.Meta.get('remote-user'),
                    displayName: AJS.I18n.getText('onboarding.sequence.comment.bot.name'),
                    profilePicture: {
                        isDefault: false,
                        path: AJS.Meta.get('static-resource-url-prefix') + '/download/resources/com.atlassian.confluence.plugins.confluence-onboarding:confluence-flow-resources/images/charliebot.png'
                    }
                },
                comment: {
                    id: 'FAKE',
                    parentId: 0,
                    html: data.value,
                    singular: '1 Comment',
                    primaryActions: [
                        {
                            id: "reply-comment",
                            label: "Reply",
                            style: "action-reply-comment",
                            url: "#"
                        },
                        {
                            id: "edit-comment",
                            label: "Edit",
                            style: "comment-action-edit",
                            url: "#"
                        },
                        {
                            id: "remove-comment",
                            label: "Delete",
                            style: "comment-action-remove",
                            url: "#"
                        },
                        {
                            label: "just a moment ago",
                            style: "comment-date",
                            url: "#"
                        }
                    ],
                    secondaryActions: []
                }
            }));

            $content.attr('id', 'comments-section-fake').addClass('onboarding-highlight');

            // disable all link inside fake comment
            $content.find('a').click(function(e) {
                e.preventDefault();
            });

            return $content;
        }

        function onConvertSuccessful(data) {
            var $commentSection = $('#comments-section');

            var $content = createFakeComment(data);
            $content.insertAfter($commentSection);

            $commentSection.hide();

            scrollTo($content);

            BaseSequence.prototype.execute.call(this, resolve);


            function scrollTo($ele) {
                $('html, body').animate({
                    scrollTop: $ele.offset().top
                }, 1000);
            }
        };
    };

    commentDemoSequence.prototype.afterShowPopup = function ($popup) {
        BaseSequence.prototype.afterShowPopup.call(this, $popup);

        // Handler the case that user active quick-edit page.
        AJS.bind('rte-quick-edit-ready', function () {
            // hide popup and backdrop
            $popup[0].remove();
           restoreCommentsSection();
        });

    };

    commentDemoSequence.prototype.onNextClicked = function (popup, event) {
        restoreCommentsSection();

        BaseSequence.prototype.onNextClicked.call(this, popup, event);
    };

    function restoreCommentsSection() {
        $('#onboarding-comment-backdrop').remove();
        $('#comments-section-fake').remove();
        $('#comments-section').show();
    }

    return commentDemoSequence;
});