define('confluence/ob/modules/intro/intro-create-space-sequence', [
    'jquery',
    'confluence/ob/common/promise',
    'confluence/ob/common/page-utils',
    'confluence/ob/modules/intro/space-creation',
    'confluence/ob/common/storage/server-storage',
    'confluence/ob/modules/intro/intro-sequence-utils'
], function ($, Promise, PageUtils, SpaceCreation, ServerStorage, IntroSequenceUtils) {
    'use strict';

    var IntroCreateSpaceSequence = function(options) {
    };

    /**
     * @type SequenceInitFunction
     */
    IntroCreateSpaceSequence.prototype.init = function(container, analytics) {
        /**
         * This sequence is resolved when space is created and new draft in the space is created successfully
         * Rejected when the step isn't valid or draft creation fails
         */
        return Promise(function(resolve, reject) {
            // In-case user leave confluence when they are in create space step. In the meantime, they lost create space permission (by configuration)
            // We should check permission again for each time this step is executed.
            if (!IntroSequenceUtils.hasStep('create-space')) {
                reject();
                return;
            }

            function disableForm(disable) {
                $button.prop('disabled', disable);
                $input.prop('disabled', disable);
            }

            var $contentEl = IntroSequenceUtils.createProgressTracker('create-space');
            var $content = $(Confluence.Templates.OB.createSpace());
            var $button = $content.find("#grow-intro-create-space");
            var $input = $content.find('#grow-intro-space-name');

            $button.prop('disabled', true);
            $input.on('keyup paste input', function() {
                var spaceName = this.value;
                var $errorEl = $('#grow-intro-space-error');

                if ($.trim(spaceName) === "") {
                    $errorEl.hide();
                    $button.prop('disabled', true);
                    return;
                }

                $button.prop('disabled', false);
            });
            $button.click(function(e) {
                e.preventDefault();
                disableForm(true);
                // No need to hide the loading indicator because it will redirect to another page after this step.
                PageUtils.showLoadingIndicator();

                SpaceCreation.createSpace($input.val())
                        .done(function(spacesDetails) {
                            var spaceKey = spacesDetails[0].key;
                            ServerStorage.setGlobal("is-first-space-created", "true");
                            PageUtils.createPageDraft(spaceKey).then(
                                    function(draftId) {
                                        resolve({spaceKey: spaceKey, draftId: draftId});
                                    },
                                    function(err) {
                                        analytics.pushEvent(IntroCreateSpaceSequence.EVENTS.CREATE_DRAFT_FAILED);
                                        reject(err);
                                    }
                            );
                        })
                        .fail(function(err) {
                            analytics.pushEvent(IntroCreateSpaceSequence.EVENTS.CREATE_SPACES_FAILED);
                            reject(err);
                        });
            });

            $contentEl.empty().append($content);
            $input.focus();
        });
    };

    IntroCreateSpaceSequence.EVENTS = {
        CREATE_SPACES_FAILED: "create.space.failed",
        CREATE_DRAFT_FAILED: "create.draft.failed"
    };

    return IntroCreateSpaceSequence;
});