define('confluence/ob/modules/intro-container/intro-container', [
    'jquery',
    'confluence/ob/modules/intro-container/page-control'
], function ($, PageController) {
    var IntroContainer = {};

    IntroContainer.createIntroContainer = function(data) {
        if ($("#grow-main-old").length === 0) {
            // if we haven't already created the survey page

            PageController.hideAllElements();
            $("html").addClass("grow-html");
            $("#page").addClass("grow-page");
            $("body").addClass("aui-page-focused aui-page-focused-large");

            var html = Confluence.Templates.OB.introContainer(data);
            $("#main").attr("id", "grow-main-old").hide()
                .after($(html));

        } else {
            $("#grow-nav-right").empty();
            $("#grow-nav-center").empty();
            $("#grow-question-text-txt").show();
            $('#main.grow-main').attr('currentstate', data.currentState);
        }
    };

    return IntroContainer;
});