define('confluence/ob/common/youtube-player', ['jquery'], function ($) {
    var YouTubePlayer = {};

    var player;
    var previousPlayerState;
    var hasVideoStarted = false;

    YouTubePlayer.EVENT_CLICK = "grow.common.youtubeplayer.click";
    YouTubePlayer.EVENT_FINISH = "grow.common.youtubeplayer.finish";

    YouTubePlayer.embedVideo = function(containerId, videoId, options) {
        if (typeof(YT) == 'undefined' || typeof(YT.Player) == 'undefined') {
            window.onYouTubePlayerAPIReady = function() {
                loadPlayer(containerId, videoId, options);
            };
            $.getScript('//www.youtube.com/player_api');
        } else {
            loadPlayer(containerId, videoId, options);
        }
    };

    YouTubePlayer.destroy = function() {
        player && player.destroy();   
    };

    YouTubePlayer.getCurrentTime = function() {
        try {
            return player.getCurrentTime();
        } catch (e) {
            return -1;
        }
    };

    YouTubePlayer.getDuration = function() {
        try {
            return player.getDuration();
        } catch (e) {
            return -1;
        }
    };

    function loadPlayer(containerId, videoId, options) {
        options = options || {};

        var origin = window.location.origin;
        if (origin) {
            origin = window.location.protocol + "//" + window.location.host;
        }

        player = new YT.Player(containerId, {
            playerVars: {
                modestbranding: 1,
                rel: 0,
                showinfo: 0,
                autoplay: options.autoplay || 0,
                origin: origin,
                cc_load_policy: options.hl ? 1 : 0,
                hl: options.hl
            },
            height: options.height || 315,
            width: options.width || 560,
            videoId: videoId,
            events: {
                'onReady': onReady,
                'onStateChange': onPlayerStateChange
            }
        });
    }

    function onReady(event) {
        previousPlayerState = player.getPlayerState();
    }

    function onPlayerStateChange(event) {
        var eventType = "";
        var clickType = "";
        var newState = event.data;

        if (newState === YT.PlayerState.ENDED) {
            eventType = YouTubePlayer.EVENT_FINISH;
        } else if (newState === YT.PlayerState.PLAYING && previousPlayerState === YT.PlayerState.PAUSED) {
            eventType = YouTubePlayer.EVENT_CLICK;
            clickType = "resume";
        } else if (newState === YT.PlayerState.PLAYING && !hasVideoStarted) {
            hasVideoStarted = true;
            eventType = YouTubePlayer.EVENT_CLICK;
            clickType = "start";
        } else if (newState === YT.PlayerState.PAUSED && previousPlayerState === YT.PlayerState.PAUSED) {
            eventType = YouTubePlayer.EVENT_CLICK;
            clickType = "skip";
        } else if (newState === YT.PlayerState.PAUSED && event.target.getCurrentTime() !== player.getDuration()) {
            eventType = YouTubePlayer.EVENT_CLICK;
            clickType = "pause";
        }

        if (eventType) {
            // If no eventType is set that means this function was triggered by the
            // CUED or BUFFERING events which are of no particular use to us

            previousPlayerState = player.getPlayerState();

            var extraParameters = {};
            if (clickType) {
                extraParameters.clickType = clickType;
            }

            $(YouTubePlayer).trigger(eventType, extraParameters);
        }
    }

    return YouTubePlayer;
});