define('confluence/ob/common/page-utils', ['jquery', 'ajs'], function($, AJS) {
    var utils = {};
    var loadingIndicator = Confluence.PageLoadingIndicator($("body"));

    utils.showLoadingIndicator = function() {
        loadingIndicator.show();
    };

    utils.hideLoadingIndicator = function() {
        loadingIndicator.hide();
    };

    utils.createPageDraft = function(spaceKey) {
       return $.ajax({
           type: "GET",
           url: AJS.contextPath() + "/rest/onboarding/1/draft/generate?spaceKey=" + spaceKey,
           contentType: "application/json",
           dataType: "json"
       });
    };

    utils.isAdmin = function() {
        return $("#admin-menu-link-conf-admin").length !== 0;
    };

    utils.isSiteAdmin = function() {
        return !!$('#admin-menu-link-site_admin_section').length;
    };

    utils.isOnSpaceHomePage = function() {
        return $("#title-heading").find("#breadcrumbs").find("li").length === 1;
    };

    utils.getContextPath = function() {
        return AJS.contextPath;
    };

    return utils;
});