(function ($) {

    // Mock notification
    ConfluenceMobile = {
        Notification: function () {
            return {
                showLoading: function () {},
                showMessage: function () {},
                hide: function () {}
            }
        }
    };

    AJS.test.require("com.atlassian.confluence.plugins.confluence-mobile:dashboard-dependencies");

    module(testPath, {
        setup: function () {
            this.collection = new ConfluenceMobile.Stream(null, {streamType: "popular", contextPath: "/confluence"});
            this.view = new ConfluenceMobile.StreamView({
                collection: this.collection,
                el: $("<div />")
            }).render();
        }
    });

    test("test add item to collection for view to update", function () {
        equal(this.view.$("#stream-items > li").length, 0, "Expect there to be no stream view elements.");

        this.collection.add([
            {author: "Alex", title: "test", friendlyDate: "posted today"},
            {author: "Dave", title: "test", friendlyDate: "posted today"},
            {author: "Bob", title: "test", friendlyDate: "posted today"},
            {author: "Rob", title: "test", friendlyDate: "posted today"},
            {author: "Marvin", title: "test", friendlyDate: "posted today"}
        ]);
        equal(this.view.$("#stream-items > li").length, 5, "Expect there to be one stream view element.");
    });

    module(testPath, {
        setup: function () {
            this.collection = new ConfluenceMobile.Stream([
                {author:"Alex", title:"test", friendlyDate:"posted today"},
                {author:"Dave", title:"test", friendlyDate:"posted today"},
                {author:"Bob", title:"test", friendlyDate:"posted today"}
            ],
                {streamType:"popular", contextPath:"confluence/"}
            );
            this.view = new ConfluenceMobile.StreamView({
                collection:this.collection,
                el:$("<div />")
            }).render();
        }
    });

    test("test presence of more button when nextPageOffset is defined", function () {
        this.collection.nextPageOffset = 42;
        this.collection.reset({author:"Alex", title:"test", friendlyDate:"posted today"});

        ok(this.view.$(".more-button").css("display") != "none", "Expect there to be a visible more button.");
    });


})(jQuery);