/**
 * The view for the complete list of comments for a page.
 */
ConfluenceMobile.CommentListView = Backbone.View.extend({

    tagName: "ol",
    className: "comment-list top-level",

    initialize: function () {
        this.model.bind("reset", this.render, this);
        this.model.bind("add", this.renderComment, this);
    },

    renderComment: function (comment) {
        if (comment.get("isResolved")) return;

        var view = new ConfluenceMobile.CommentView({model: comment, commentListView: this});

        // If this is a new comment then set the view to be editable
        if (comment.id == 0) {
            view.toggleEdit(true);
        }

        // render toplevel or child comment
        var parentId = comment.get("parentId");
        if (parentId) {
            var parentComment = this.$("#comment-" + parentId);
            parentComment.children(".comment-list").append(view.render().$el);
        } else {
            this.$el.append(view.render().$el);
        }

        // only show one comment editor at a time
        this.on("reply-to-comment", function (view) {
            if (this.currentReplyView && this.currentReplyView.editing) {
                this.currentReplyView.remove();
                this.currentReplyView.uploader && this.currentReplyView.uploader.destroy();
            }

            this.currentReplyView = view;
        }, this);
    },

    render: function () {
        this.$el.empty(); // clear any previous rendering
        this.model.each(this.renderComment, this);

        return this;
    }
});