/**
 * Copied more or less from jira-mobile tracking.js
 *
 * This resource has been removed from the mobile batch. It previously used Google analytics
 * to provide analytics data, but Atlassian no longer uses Google analytics because it has no control
 * over the data. This file could be re-inserted into the batch if we could bring in Atlassian analytics
 * javascript, however, that javascript depends on AUI and AUI cannot be loaded into Confluence mobile. If
 * attempting to get analytics to work, you need to include the following dependency
 * <dependency>com.atlassian.analytics.analytics-client:js-events</dependency> and clean this file up.
 */
Zepto(function () {
    // This are overridden if the appData key "analytics-enabled" is set to false
    var analyticsEnabled = ConfluenceMobile.AppData.getBoolean('analytics-enabled');

    var mappers = [];
    var tracker = {
        trackPageview: function (page) {
            _.each(mappers, function (mapper) {
                mapper.pageview(page);
            });
        },

        trackEvent: function (noun, verb, data) {
            _.each(mappers, function (mapper) {
                mapper.event(noun, verb, data);
            });
        }
    };

//    // Track route changes
//    ConfluenceMobile.routerEventAggregator.bind("change", function () {
//        // defer to get the hash fragment when going to root url
//        _.defer(function() {
//            tracker.trackPageview(Backbone.history.fragment);
//        })
//    });
//
//    AJS.EventQueue = AJS.EventQueue || [];
//
//    mappers.push({
//        pageview: function (page) {
//            this.event('page', 'view', {page: page});
//        },
//        event: function (noun, verb, data) {
//            var name = ['mobile', noun, verb].join('.');
//            var obj = {name: name};
//            if (data) {
//                obj.properties = data;
//            }
//            // Stolen from jira-issue-nav-plugin/src/main/resources/content/js/util/ClientAnalytics.js
//            var logMsg = "***** Analytics log [" + name + "]";
//            if (data) {
//                logMsg += "[" + JSON.stringify(data) + "]";
//            }
//            // console && console.log(logMsg);
//            // Do the actual tracking
//            AJS.EventQueue.push(obj);
//        }
//    });

    // publish tracker object
    _.extend(ConfluenceMobile.Analytics, tracker);
});
