(function ($) {

    var isMobileSafari = /iPhone|iPad|iPhone/.test(navigator.userAgent);

    var viewportHeight = window.innerHeight;


    ConfluenceMobile.hideAddressBar = function () {
        if (!isMobileSafari || ConfluenceMobile.Scrolling.hasSavedPosition()) {
            return;
        }

        // Sometimes we don't need to wait!
        window.scroll(0, 1);

        var $outerContainer = $("#outer-container");

        var documentHeight = document.height,
            tooShort = documentHeight <= viewportHeight;

        // Why 61?
        // 60 is the height of Mobile Safari's address bar,
        // and the 1 is so the window.scroll(0, 1) is
        // consistent when the page's height is already
        // taller than necessary to add the height.
        tooShort && $outerContainer.css("min-height", viewportHeight + 61);

        setTimeout(function () {
            window.scroll(0, 1);
        }, 50);

    };

    $(window)
        .bind("load", function () {
            if (!window.pageYOffset) {
                ConfluenceMobile.hideAddressBar();
            }
        })
        .bind("orientationchange", function() {
            viewportHeight = window.innerHeight;
            ConfluenceMobile.hideAddressBar();
        });

    $(document).bind("hashchange", ConfluenceMobile.hideAddressBar);

})(Zepto);