Zepto(function ($) {
    var $searchInput = $("#search-input"),
        $clearSearchInput = $("#clear-search-input"),
        $searchResults = $("#search-results"),
        $noResultsMessage = $(".no-results-message"),
        $searchInProgress = $(".search-in-progress");

    var types = ["content"];
    if (ConfluenceMobile.AppData.getBoolean("permission-view-user-profiles")) {
        types.push("userinfo");
    }
    
    $searchResults.on("click", ".search-item a", cancelSearch);

    $clearSearchInput.click(function () {
        $searchInput.val("").trigger("search");
    });

    $searchInput.bind("focus", function (event) {
        /**
         * When user focuses on the search field, mobile safari opens the on-screen keyboard _and_ shows the address bar (even if it was previously hidden)
         * Its important that we hide it to maximise the vertical real estate between the search field and the on-screen keyboard for displaying search results.
         */
        ConfluenceMobile.hideAddressBar();
        ConfluenceMobile.flyout.expandWidth();
    });
    
    $searchInput.bind("blur", function (event) {
        if (!$searchInput.val().trim()) {
            cancelSearch();
        }
    });

    $searchInput.keyup(function () {
        $clearSearchInput.toggleClass("activated", !!$(this).val().trim());
    });

    $searchInput.bind("search", function () {

        $searchResults.hide();
        $noResultsMessage.hide();

        var query = $searchInput.val();
        if (!query) {
            return;
        }

        $searchInProgress.show();

        // $.param is used with 'shallow' so that type is not serialized to 'type[]'. 
        $.ajax({
            url: ConfluenceMobile.AppData.get("confluence-context-path") + "/rest/quicknav/1/search",
            data: $.param({
                query: query,
                type: types,
                maxPerCategory: 5
            }, true), 
            dataType: "json",
            success: function (data) {


                if (data.errorMessage) {
                        ConfluenceMobile._buildModal({
                            message:  AJS.I18n.getText("confluence.mobile.login.possibly.required"),
                            buttons: [
                                {
                                    type: "primary",
                                    text: "Login",
                                    event: function() {
                                        ConfluenceMobile.loadLoginScreen();
                                    }
                                },

                                {
                                    type: "",
                                    text: "Cancel",
                                    event: function(modal) {
                                        modal.destroy();
                                    }
                                }
                            ]
                        }).show();

                    $searchInProgress.hide();
                    return;
                }

                if ($searchInput.val() != data.query) {
                    return; // if the query inside the search box has changed, then discard the result
                }

                $searchInProgress.hide();

                var contentNameMatches = data.contentNameMatches || [],
                    length = 0,
                    results = {
                        content: [],
                        user: []
                    };


                _.each(_.flatten(contentNameMatches), function (contentNameMatch) {
                    if (!/^content-type-(blogpost|userinfo|page)$/.test(contentNameMatch.className)) {
                        return;
                    }

                    length++;

                    var key = contentNameMatch.className == "content-type-userinfo" ? "user" : "content";

                    // produce a single page app friendly url from the original href and then assign it
                    try
                    {
                        contentNameMatch.href = getMobileUrl(contentNameMatch);
                    }
                    catch (e)
                    {
                        // leave the original href alone. Better to have a desktop URL that produces a page refresh than no URL at all.
                    }

                    results[key].push(Confluence.Templates.Mobile.Search.item({ result: contentNameMatch }));
                });

                $noResultsMessage.toggle(length === 0);

                if (length > 0) {
                    $searchResults.html(Confluence.Templates.Mobile.Search.results({ results: results })).show();
                }
            }



        });
    });

    $("#search-cancel").click(cancelSearch);

    function cancelSearch() {
        $noResultsMessage.hide();
        $searchResults.hide();
        $searchInput.val("").trigger("keyup");
        $searchInProgress.hide();

        ConfluenceMobile.flyout.restoreWidth();
    };
    
    function getMobileUrl(contentNameMatch) {
        if (contentNameMatch.className == "content-type-userinfo") {
            if (!contentNameMatch.username) {
                throw new Error("Expected username value to be present in userinfo result but was not found.");
            }

            return "#profile/" + contentNameMatch.username;
        } else {
            if (!contentNameMatch.id) {
                throw new Error("Expected id value to be present in quick nav result but was not found.");
            }

            return "#content/view/" + contentNameMatch.id;
        }
    }

    $searchInput.bind("focus", function () {
        ConfluenceMobile.Analytics.trackEvent("search", "focus");
    });
});