(function () {

    var tops = {};

    ConfluenceMobile.Scrolling = {
        savePosition: function () {
            tops[window.location.hash] = document.body.scrollTop;
        },

        restorePosition: function () {
            var scrollTop = tops[window.location.hash];
            if (scrollTop) {
                setTimeout(function () {
                    window.scroll(0, +scrollTop);
                }, 5);
            }
        },

        hasSavedPosition: function () {
            return tops.hasOwnProperty(window.location.hash);
        },

        resetByHash: function (hash) {
            delete tops[hash];
        }
    };

    /**
     * document.body.scrollTop stores the offset (in number of pixels) from the top of the view port.
     *
     * This handler stores the value of scrollTop at the end of each touch move (when the user lifts their finger after a scroll).
     * The value is stored against the location hash so should work on dashboard and page views.
     */
    $(document).bind("touchmove", ConfluenceMobile.Scrolling.savePosition);

})();

