/**
 * Dark features are features that can enabled and disabled per user via a feature key. Their main use is to allow
 * in-development features to be rolled out to production in a low-risk fashion.
 */
(function ($) {
    var featuresStr = $('meta[name=ajs-enabled-dark-features]').attr("content"),
        featuresArr = featuresStr ? featuresStr.split(',') : [],
        features = {};

    _.each(featuresArr, function (feature) {
        features[feature] = true;
    });
    

    AJS.DarkFeatures = {
        isEnabled: function (key) {
            return !!features[key];
        },

        enable: function (key) {
            if (key && !features[key])
                features[key] = true;
        },

        disable: function (key) {
            if (key && features[key])
                delete features[key];
        },

        getAllEnabled: function() {
            return featuresArr;
        }
    };
})($);

