/**
 * Event aggregators remove the need to bind directly to objects, which may not be possible
 * depending on the ordering of dependency loading.
 *
 * Aggregators should be added as required.
 */
ConfluenceMobile.routerEventAggregator = _.extend({}, Backbone.Events);

/**
 * This aggregator should is used for events related to the handling of pages/screens of the application
 */
ConfluenceMobile.pageEventAggregator = _.extend({}, Backbone.Events);

/**
 * This aggregator is used for events related to the handling of Confluence "content" which includes
 * comments, pages and blogs.
 */
ConfluenceMobile.contentEventAggregator = _.extend({}, Backbone.Events);

/**
 *  This aggregator is used for events related to uploading photos when creating a comment.
 */
ConfluenceMobile.photoUploaderEventAggregator = _.extend({}, Backbone.Events);