/**
 * Reverse the affects of textToHtml so we can display the comment text
 * in a textarea.
 *
 * @html the html content of a comment
 * @mentionMarkup an array containing markup to substitute for mentions text. The comment creation REST resource
 *     only understands editor HTML format, so mentions need to be in the HTML format.
 *     mentionMarkup = [{
 *         mentionString: '[@Ted Piotrowski]',
 *         html: '<a class="confluence-userlink user-mention" data-username="...>...</a>'
 *     }]
 */
ConfluenceMobile.htmlToText = function(html, mentionMarkup) {
    html = html.replace(/<\/p><p>/g, "\n\n").replace(/<p>|<\/p>/g, "").replace(/<br\/>/g,"\n").replace(/<img.+?\/(\w+.(png|jpg|jpeg|gif)).+?>/gi, '!$1!');
    if (mentionMarkup) {
        for (var i = 0; i < mentionMarkup.length; i++) {
            html = html.replace(mentionMarkup[i].html, mentionMarkup[i].mentionString);
        }
    }
    return html;
};