/**
 * Wire up watch button when the content has been rendered.
 */
define('confluence-mobile/watch-control',
    [
        'confluence-mobile/watch-model',
        'confluence-mobile/watch-view',
        'window'
    ], function (WatchModel, WatchView, window) {
        var contentRenderedHandler = function (pageView, $container, contentModel) {

            var watch = new WatchModel({
                watching: contentModel.get('watching'),
                contentId: contentModel.contentId
            });

            new WatchView({
                el: $container.find('.content-watch')[0],
                model: watch
            }).render();
        };

        window.ConfluenceMobile.contentEventAggregator && window.ConfluenceMobile.contentEventAggregator.on('render:pre:after-content', contentRenderedHandler);
    });

require('confluence/module-exporter').safeRequire('confluence-mobile/watch-control', function (WatchControl) {
    require('ajs').toInit(WatchControl);
});