/**
 * Script for the desktop app which provides the mechanism to switch back to the mobile application.
 */
AJS.$(function() {
    Confluence.MobileSwitch = {


        switchToMobile: function(e) {
            AJS.$.cookie("confluence.mobile.desktop.switch", null, Confluence.MobileSwitch._cookieOptions); // this cookie name matches desktop-switch.js

            // remove the desktop=true request parameter if it is present
            if (window.location.href.match(/[?&;]desktop=true/)) {
                var href = window.location.href.replace(/desktop=true&?/,"")
                window.location = href;
            } else {
                window.location.reload();
            }
        },

        initialise: function() {

            $messageContainer = AJS.$("#messageContainer");

            // If the element does not exist, it will be created.
            !$messageContainer.length && ($messageContainer = AJS.$("<ul id='messageContainer' />").appendTo("#header-precursor .cell"));

            $messageContainer.append(Confluence.Templates.Mobile.Switch.returnToMobileBanner());

            Confluence.MobileSwitch._cookieOptions = {
                expires: 3650,
                path: AJS.Meta.get("context-path") || "/",
                raw: true
            };

            $messageContainer.find("a").click(Confluence.MobileSwitch.switchToMobile);
        }
    };

    Confluence.MobileSwitch.initialise();
});
