/**
 * Keep the 'switch to desktop' link in the flyout up to date with the current context of the application.
 *
 * This is dependent on the ConfluenceMobile.router having been created already.
 */
$(function($){
    ConfluenceMobile.DesktopSwitch = {

        $desktopLink: $("#switch-to-desktop"),

        _cookieName: "confluence.mobile.desktop.switch",

        /**
         * The route names here must match the route names created in router.js
         */
        _routeToUrlMappers: {
            "viewContent": function(args) {
                var url = null;
                if (args && args.length > 0) {
                    url = "pages/viewpage.action?pageId=" + args[0];
                    if (args.length > 1) {
                        url = url + "&focusedCommentId=" + args[1] + "#comment-" + args[1];
                    }
                }

                return url;
            },

            "profile": function(args) {
                var url = null;
                if (args && args.length == 1) {
                    url = "display/~" + args[0];
                }

                return url;
            },

            "dashboard": function(args) {
                var url = "dashboard.action?updatesSelectedTab=";
                var query = "all";
                if (args && args.length > 0) {
                    if (args[0] == "popular") {
                        query = "popular";
                    } else if (args[0] == "network") {
                        query = "network";
                    }
                }

                return url + query;
            }
        },

        /**
         * Parse a route and create the relative link that would take you to the desktop
         * version of this route.
         *
         * @param route the route to be converted
         * @return the desktop version of this route or null if no desktop route can be determined
         */
        _convertRouteToDesktopUrl: function(name, args) {
            var mapper = ConfluenceMobile.DesktopSwitch._routeToUrlMappers[name];
            if (!mapper) {
                return null;
            }

            return mapper(args);
        },

        /**
         * Should be called when a route is changed in the application.
         *
         * @param route the route template
         * @param name the name of the route (the function it will call in the Router)
         * @param args the arguments
         */
        routeChangeHandler: function(route, name, args) {
            var desktopUrl = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl(name,args);

            if (!desktopUrl) {
                desktopUrl = ConfluenceMobile.AppData.get("default-desktop-url");
            } else {
                desktopUrl = ConfluenceMobile.AppData.get("confluence-context-path") + "/" + desktopUrl;
            }

            ConfluenceMobile.DesktopSwitch.$desktopLink.attr("href", desktopUrl);
        },

        /**
         * Called when the user chooses to switch to the desktop version of the application.
         * Will set a cookie which makes the switch persistent for this browser.
         *
         * @param e
         */
        desktopSwitchHandler: function(e) {
            var path = ConfluenceMobile.AppData.get("confluence-context-path");
            if (!path) {
               path = "/";
            }

            var cookieOptions = {
               expires: 3650, // 10 years from now
               path: path,
               raw: true
            };

            if (Cookies.get(ConfluenceMobile.DesktopSwitch._cookieName)) {
               // erase the current cookie so we can set a new one with a newly
               // set far-future date
               Cookies.set(ConfluenceMobile.DesktopSwitch._cookieName, null,cookieOptions);
            }

            Cookies.set(ConfluenceMobile.DesktopSwitch._cookieName, "true", cookieOptions);
            ConfluenceMobile.Analytics.trackEvent("flyout", "switch-to-desktop");
        }
    };

    ConfluenceMobile.routerEventAggregator.bind("change", ConfluenceMobile.DesktopSwitch.routeChangeHandler);

    ConfluenceMobile.DesktopSwitch.$desktopLink.on("click", ConfluenceMobile.DesktopSwitch.desktopSwitchHandler);
});
