(function ($) {

    AJS.test.require(["com.atlassian.confluence.plugins.confluence-mobile:fly-out-resources"], function () {
        var module = QUnit.module;
        var test = QUnit.test;
        module("test convert route to desktop url", function () {
            test("viewing content but content Id missing", function(assert){
                var url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("viewContent", []);
                assert.equal(url, null);

                url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("viewContent", null);
                assert.equal(url, null);
            });

            test("viewing content", function (assert) {
                var url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("viewContent", ["12345"]);
                assert.ok(url.match(/\?pageId=12345$/));
            });

            test("viewing content focused on a comment", function(assert) {
                var url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("viewContent", ["12345", "6789"]);
                assert.ok(url.match(/\?pageId=12345\&focusedCommentId=6789#comment-6789$/));
            });

            test("viewing a profile", function(assert) {
                var url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("profile", ["jimbobwalton"]);
                assert.ok(url.match(/~jimbobwalton$/));
            });

            test("viewing dashboard tabs", function(assert){
                var url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("dashboard", null);
                assert.ok(url.match(/all$/));

                url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("dashboard", ["popular"]);
                assert.ok(url.match(/popular$/));

                url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("dashboard", ["network"]);
                assert.ok(url.match(/network/));

                url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("dashboard", ["recentblogs"]);
                assert.ok(url.match(/all$/));
            });
        });
    });
})(jQuery);