/**
 * Confluence comments are actually hierarchical but in Confluence Mobile we flatten them to a list.
 */
ConfluenceMobile.CommentList = Backbone.Collection.extend({           
    
    model: ConfluenceMobile.Comment,
    
    contentId: 0,
    contextPath: "",
    canComment: false,
    
    initialize: function(models, options) {
        this.bind('sync', this.addNewCommentPlaceholder, this);
        this.bind('reset', this.addNewCommentPlaceholder, this);
        
        options = options || {};

        if (options.contentId == undefined) {
            throw new Error("content ID is required.");
        }
        
        this.contentId = options.contentId;
        this.contextPath = options.contextPath;
        this.canComment = options.canComment;

    },
    
    /**
     * Called to add a new comment place holder if there isn't one
     * already.
     */
    addNewCommentPlaceholder: function() {
        if (this.canComment) {
            var newComment = this.get(0);
            if (!newComment) {
                this.add(new ConfluenceMobile.Comment( { ownerId: this.contentId } ));
            }            
        }
    },
    
    setCanComment: function(canComment) {
        if (canComment != this.canComment) {
            this.canComment = canComment;
            if (this.canComment) {
                this.addNewCommentPlaceholder();
            }
        }
    },
    
    url: function() {
        return this.contextPath + "/rest/mobile/1.0/content/" + this.contentId + "/comments";
    }
    
});